import React, { useEffect, useState } from 'react';
import DialogUmum from 'src/shared/components/dialog/DialogUmum';
import DialogContent from '@mui/material/DialogContent';
import ListDetailBuilder from '../ListDetailItem';
import StatusChip from '../StatusChip';
import dayjs from 'dayjs';
import utc from 'dayjs/plugin/utc';
import timezone from 'dayjs/plugin/timezone';
import {
  getDetailTransaksiText,
  getDokumenTransaksiText,
  getKdTransaksiText,
} from '../../constant';

dayjs.extend(utc);
dayjs.extend(timezone);

interface ModalCetakDokumenLainMasukanProps {
  payload?: Record<string, any>;
  isOpen: boolean;
  onClose: () => void;
}

type Row = { label: string; value: React.ReactNode };

const ModalCetakDokumenLainMasukan: React.FC<ModalCetakDokumenLainMasukanProps> = ({
  payload,
  isOpen,
  onClose,
}) => {
  const [rows, setRows] = useState<Row[]>([]);

  useEffect(() => {
    if (!payload) return;

    const formattedRows: Row[] = [
      {
        label: 'NPWP Penjual',
        value: payload.npwppembeli,
      },
      {
        label: 'Nama Penjual',
        value: payload.namapenjual,
      },
      {
        label: 'Kode Dokumen',
        value: getDokumenTransaksiText(payload.dokumentransaksi),
      },
      { label: 'Nomor Dokumen', value: payload.nomordokumen },
      {
        label: 'Tanggal Dokumen',
        value: payload.tanggaldokumen
          ? dayjs(payload.tanggaldokumen).local().format('DD/MM/YYYY')
          : '-',
      },
      {
        label: 'Masa Pajak',
        value: payload.masapajak,
      },
      {
        label: 'Tahun Pajak',
        value: payload.tahunpajak,
      },
      {
        label: 'Status',
        value: <StatusChip value={payload.statusdokumen} />,
      },
      {
        label: 'Jumlah DPP',
        value: `${Number(payload.jumlahdpp || 0)}`,
      },

      {
        label: 'Jumlah PPN',
        value: `${Number(payload.jumlahppn || 0)}`,
      },
      {
        label: 'Jumlah PPnBM',
        value: `${Number(payload.jumlahppnbm || 0)}`,
      },
      {
        label: 'Tanggal Approval',
        value: payload.tanggalapproval
          ? dayjs(payload.tanggalapproval).local().format('DD/MM/YYYY')
          : '-',
      },
      {
        label: 'Nama Penandatangan',
        value: payload.namapenandatangan || '-',
      },
      {
        label: 'Keterangan Tambahan',
        value: payload.keterangantambahan || '-',
      },
      {
        label: 'Referensi',
        value: payload.referensi || '-',
      },
      {
        label: 'NPWP Pembeli',
        value: payload.npwppembeli,
      },
      { label: 'Kode Transaksi', value: getKdTransaksiText(payload.kdtransaksi) },
      {
        label: 'Nama Pembeli',
        value: payload.namapembeli,
      },
      { label: 'Kode Transaksi', value: getKdTransaksiText(payload.kdtransaksi) },
      {
        label: 'Detail Transaksi',
        value: getDetailTransaksiText(payload.detailtransaksi),
      },
      {
        label: 'User Perekam',
        value: payload.created_by || '-',
      },
      {
        label: 'Tanggal Rekam',
        value: payload.created_at ? dayjs(payload.created_at).local().format('DD/MM/YYYY') : '-',
      },

      {
        label: 'User Pengubah',
        value: payload.updated_by || '-',
      },
      {
        label: 'Tanggal Ubah',
        value: payload.updated_at ? dayjs(payload.updated_at).local().format('DD/MM/YYYY') : '-',
      },
    ];

    setRows(formattedRows);
  }, [payload]);

  return (
    <DialogUmum maxWidth="lg" isOpen={isOpen} onClose={onClose} title="Detail Dokumen Lain Masukan">
      <DialogContent classes={{ root: 'p-16 sm:p-24' }}>
        <ListDetailBuilder rows={rows} />
      </DialogContent>
    </DialogUmum>
  );
};

export default ModalCetakDokumenLainMasukan;
