import { useMutation } from '@tanstack/react-query';
import type { TCancelDnRequest, TCancelDnResponse } from '../types/types';
import dnApi from '../utils/api';

const useCancelDn = (props?: any) =>
  useMutation<TCancelDnResponse, Error, TCancelDnRequest>({
    mutationKey: ['cancel-dn'],
    mutationFn: (payload) => dnApi.cancel(payload),
    ...props,
  });

export default useCancelDn;
