import Grid from '@mui/material/Grid';
import dayjs from 'dayjs';
import { useEffect } from 'react';
import { useFormContext } from 'react-hook-form';
// import { useParams } from 'react-router';
import { Field } from 'src/components/hook-form';

type IdentitasProps = {
  isPengganti?: boolean;
};

const Identitas = ({ isPengganti }: IdentitasProps) => {
  const { setValue, watch } = useFormContext();
  const tanggalPemotongan = watch('tglPemotongan');

  // auto set thnPajak dan msPajak berdasarkan tanggalPemotongan
  useEffect(() => {
    if (!isPengganti) {
      if (tanggalPemotongan) {
        const date = dayjs(tanggalPemotongan);
        setValue('tahunPajak', date.format('YYYY'));
        setValue('masaPajak', date.format('MM'));
        setValue('tanggalDokumenReferensi', date)
      } else {
        setValue('tahunPajak', '');
        setValue('masaPajak', '');
      }
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [tanggalPemotongan, !isPengganti]);

  return (
    <>
      <Grid container rowSpacing={2} alignItems="center" columnSpacing={2} sx={{ mb: 4 }}>
        <Grid size={{ md: 6 }}>
          <Field.DatePicker
            name="tglPemotongan"
            label="Tanggal Pemotongan"
            format="DD/MM/YYYY"
            maxDate={dayjs()}
          />
        </Grid>
        <Grid size={{ md: 3 }}>
          <Field.DatePicker
            name="tahunPajak"
            label="Tahun Pajak"
            view="year"
            format="YYYY"
            readOnly
            disabled={isPengganti}
          />
        </Grid>
        <Grid size={{ md: 3 }}>
          <Field.DatePicker
            name="masaPajak"
            label="Masa Pajak"
            view="month"
            format="MM"
            readOnly
            disabled={isPengganti}
          />
        </Grid>

        {/* NPWP dengan onChange langsung */}
        <Grid size={{ md: 6 }}>
          <Field.Text
            name="npwp"
            label="NPWP"
            onChange={(e) => {
              const value = e.target.value.replace(/\D/g, '').slice(0, 16); // hanya angka, max 16
              setValue('npwp', value, { shouldValidate: true, shouldDirty: true });
              setValue('nitku', value.length === 16 ? value + '000000' : value, {
                shouldValidate: true,
                shouldDirty: true,
              });
            }}
            disabled={isPengganti}
          />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Text
            name="nitku"
            label="NITKU"
            disabled={isPengganti}
          />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Text name="namaDipotong" label="Nama" disabled={isPengganti} />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Text name="alamatDipotong" label="Alamat" />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Text name="email" label="Email (optional)" disabled={isPengganti} />
        </Grid>
      </Grid>

      {/* Tambah / Hapus Keterangan */}
      {/* <Box sx={{ display: 'flex', gap: 2, mb: 3 }}>
        <Box
          sx={{
            borderRadius: '18px',
            border: jumlahKeterangan >= maxKeterangan ? '1px solid #eee' : '1px solid #2e7d3280',
            color: jumlahKeterangan >= maxKeterangan ? '#eee' : '#2e7d3280',
            p: '0px 10px',
          }}
        >
          <Button disabled={jumlahKeterangan >= maxKeterangan} onClick={handleTambah}>
            Tambah Keterangan
          </Button>
        </Box>
        <Box
          sx={{
            borderRadius: '18px',
            border: jumlahKeterangan === 0 ? '1px solid #eee' : '1px solid #f44336',
            color: jumlahKeterangan === 0 ? '#eee' : '#f44336',
            p: '0px 10px',
          }}
        >
          <Button disabled={jumlahKeterangan === 0} onClick={handleHapus}>
            Hapus Keterangan
          </Button>
        </Box>
      </Box>

      <Box sx={{ mb: 3 }}>
        {Array.from({ length: jumlahKeterangan }).map((_, i) => (
          <Grid size={{ md: 12 }} key={i}>
            <Field.Text
              sx={{ mb: 2 }}
              name={`keterangan${i + 1}`}
              label={`Keterangan Tambahan ${i + 1}`}
            />
          </Grid>
        ))}
      </Box> */}
    </>
  );
};

export default Identitas;
