import {
  FG_PERHITUNGAN,
  JENIS_PERHITUNGAN,
  KODE_OBJEK_PAJAK,
  PERHITUNGAN_BUPOT21,
} from './bupot-bulanan/constant';

export type paramsHitung = {
  kodeObjekPajak: string;
  fgPerhitungan: string;
  jenisPerhitungan: string;
  phBruto: number;
};

export const checkPerhitunganBupot21 = ({
  kodeObjekPajak,
  fgPerhitungan,
  jenisPerhitungan,
  phBruto,
}: paramsHitung) => {
  switch (kodeObjekPajak) {
    case KODE_OBJEK_PAJAK.BULANAN_01:
    case KODE_OBJEK_PAJAK.BULANAN_02:
    case KODE_OBJEK_PAJAK.BULANAN_03:
    case KODE_OBJEK_PAJAK.TIDAK_FINAL_10:
      console.log('fgPerhitungan', fgPerhitungan, kodeObjekPajak, jenisPerhitungan, phBruto);
      if (fgPerhitungan == FG_PERHITUNGAN.GROSS) return PERHITUNGAN_BUPOT21.BULANAN_GROSS;
      if (fgPerhitungan == FG_PERHITUNGAN.GROSS_UP) return PERHITUNGAN_BUPOT21.BULANAN_GROSS_UP;
      if (fgPerhitungan == FG_PERHITUNGAN.MIXED) return PERHITUNGAN_BUPOT21.BULANAN_MIXED;
      return null;
    case KODE_OBJEK_PAJAK.TIDAK_FINAL_03:
      if (jenisPerhitungan == JENIS_PERHITUNGAN.BULANAN) {
        if (fgPerhitungan == FG_PERHITUNGAN.GROSS) return PERHITUNGAN_BUPOT21.BULANAN_GROSS;
        if (fgPerhitungan == FG_PERHITUNGAN.GROSS_UP) return PERHITUNGAN_BUPOT21.BULANAN_GROSS_UP;
        if (fgPerhitungan == FG_PERHITUNGAN.MIXED) return PERHITUNGAN_BUPOT21.BULANAN_MIXED;
      }
      if (jenisPerhitungan == JENIS_PERHITUNGAN.HARIAN) {
        if (phBruto <= 2500000) return PERHITUNGAN_BUPOT21.HARIAN;
        if (phBruto > 2500000) return PERHITUNGAN_BUPOT21.PASAL17;
      }
      return null;
    case KODE_OBJEK_PAJAK.TIDAK_FINAL_04:
    case KODE_OBJEK_PAJAK.TIDAK_FINAL_05:
    case KODE_OBJEK_PAJAK.TIDAK_FINAL_06:
    case KODE_OBJEK_PAJAK.TIDAK_FINAL_07:
    case KODE_OBJEK_PAJAK.TIDAK_FINAL_09:
    case KODE_OBJEK_PAJAK.TIDAK_FINAL_11:
    case KODE_OBJEK_PAJAK.TIDAK_FINAL_12:
    case KODE_OBJEK_PAJAK.TIDAK_FINAL_13:
      return PERHITUNGAN_BUPOT21.PASAL17;
    case KODE_OBJEK_PAJAK.FINAL_01:
    case KODE_OBJEK_PAJAK.FINAL_02:
      return PERHITUNGAN_BUPOT21.FINAL;
    default:
      return null;
  }
};
