export type Status = 'DRAFT' | 'APPROVED' | 'WAITING FOR AMENDMENT' | 'AMENDED' | 'CANCELLED';

export interface StatusOption {
  value: Status;
  label: string;
}

export const STATUS_OPTIONS: StatusOption[] = [
  { value: 'DRAFT', label: 'Draft' },
  { value: 'APPROVED', label: 'Normal' },
  { value: 'WAITING FOR AMENDMENT', label: 'Normal Pengganti' },
  { value: 'AMENDED', label: 'Diganti' },
  { value: 'CANCELLED', label: 'Batal' },
];

// helper (biar formatter rapi)
export const getStatusLabel = (value?: string) =>
  STATUS_OPTIONS.find((opt) => opt.value === value)?.label ?? value;
