export const DETAIL_TRANSAKSI = {
  PENYERAHAN_NON_PEMUNGUT: 'TD.00301',
  PENYERAHAN_PEMUNGUT_PEMERINTAH: 'TD.00302',
  PENYERAHAN_PEMUNGUT_NON_PEMERINTAH: 'TD.00303',
  DPP_LAIN: 'TD.00304',
  PERSENTASE_TERTENTU: 'TD.00305',
  TURIS_RESTITUSI: 'TD.00306',
  PPN_TIDAK_DIPUNGUT: 'TD.00307',
  PPN_DIBEBASKAN: 'TD.00308',
  PENJUALAN_ASET: 'TD.00309',
  TARIF_TIDAK_NORMAL: 'TD.00310',
  EKSPOR_BERWUJUD: 'TD.00311',
  EKSPOR_TIDAK_BERWUJUD: 'TD.00312',
  EKSPOR_JASA: 'TD.00313',
  IMPOR_BERWUJUD: 'TD.00314',
  IMPOR_TIDAK_BERWUJUD: 'TD.00315',
} as const;

export type DetailTransaksi = (typeof DETAIL_TRANSAKSI)[keyof typeof DETAIL_TRANSAKSI];

export interface DetailTransaksiOption {
  value: DetailTransaksi;
  label: string;
}

export const DETAIL_TRANSAKSI_OPTIONS: DetailTransaksiOption[] = [
  {
    value: DETAIL_TRANSAKSI.PENYERAHAN_NON_PEMUNGUT,
    label: 'Kepada PKP Penjual selain Pemungut PPN',
  },
  {
    value: DETAIL_TRANSAKSI.PENYERAHAN_PEMUNGUT_PEMERINTAH,
    label: 'Kepada Pemungut PPN Instansi Pemerintah',
  },
  {
    value: DETAIL_TRANSAKSI.PENYERAHAN_PEMUNGUT_NON_PEMERINTAH,
    label: 'Kepada Pemungut PPN selain Instansi Pemerintah',
  },
  {
    value: DETAIL_TRANSAKSI.DPP_LAIN,
    label: 'Penyerahan yang menggunakan Dasar Pengenaan Pajak (DPP) Nilai Lain',
  },
  {
    value: DETAIL_TRANSAKSI.PERSENTASE_TERTENTU,
    label: 'Penyerahan yang PPN-nya dipungut dengan besaran tertentu',
  },
  {
    value: DETAIL_TRANSAKSI.TURIS_RESTITUSI,
    label: 'Kepada pemegang paspor luar negeri dalam rangka VAT Refund for Tourist',
  },
  {
    value: DETAIL_TRANSAKSI.PPN_TIDAK_DIPUNGUT,
    label:
      'Penyerahan yang mendapat fasilitas PPN dan/atau PPnBM Tidak Dipungut atau Ditanggung Pemerintah',
  },
  {
    value: DETAIL_TRANSAKSI.PPN_DIBEBASKAN,
    label: 'Penyerahan yang mendapat fasilitas dibebaskan dari pengenaan PPN dan/atau PPnBM',
  },
  {
    value: DETAIL_TRANSAKSI.PENJUALAN_ASET,
    label: 'Penyerahan aktiva yang menurut tujuan semula tidak untuk diperjualbelikan',
  },
  {
    value: DETAIL_TRANSAKSI.TARIF_TIDAK_NORMAL,
    label: 'Untuk penyerahan lainnya',
  },
  {
    value: DETAIL_TRANSAKSI.EKSPOR_BERWUJUD,
    label: 'Ekspor BKP Berwujud',
  },
  {
    value: DETAIL_TRANSAKSI.EKSPOR_TIDAK_BERWUJUD,
    label: 'Ekspor BKP Tidak Berwujud',
  },
  {
    value: DETAIL_TRANSAKSI.EKSPOR_JASA,
    label: 'Ekspor JKP',
  },
  {
    value: DETAIL_TRANSAKSI.IMPOR_BERWUJUD,
    label: 'Impor BKP',
  },
  {
    value: DETAIL_TRANSAKSI.IMPOR_TIDAK_BERWUJUD,
    label: 'Pemanfaatan BKP Tidak Berwujud dan JKP',
  },
];

// helper untuk grid / formatter / fallback
export const getDetailTransaksiLabel = (value?: string) =>
  DETAIL_TRANSAKSI_OPTIONS.find((opt) => opt.value === value)?.label ?? value;
