export const DOKUMEN_TRANSAKSI = {
  DOKUMEN_DIPERSAMAKAN: 'OSD.00601',
  CUKAI_ROKOK: 'OSD.00602',
  DOKUMEN_KAWASAN_BERIKAT: 'OSD.00603',
  PEMBERITAHUAN_EKSPOR_BARANG: 'OSD.00604',
  PEMBERITAHUAN_EKSPOR_JASA: 'OSD.00605',
  PEMBERITAHUAN_IMPOR_BAYAR: 'OSD.00606',
  PEMBAYARAN: 'OSD.00607',
  DOKUMEN_TERTENTU: 'OSD.00608',
  SKPKB_SKPKBT: 'OSD.00609',
  PEMBERITAHUAN_IMPOR: 'OSD.00610',
} as const;

export type DokumenTransaksi = (typeof DOKUMEN_TRANSAKSI)[keyof typeof DOKUMEN_TRANSAKSI];

export interface DokumenTransaksiOption {
  value: DokumenTransaksi;
  label: string;
}

export const DOKUMEN_TRANSAKSI_OPTIONS: DokumenTransaksiOption[] = [
  {
    value: DOKUMEN_TRANSAKSI.DOKUMEN_DIPERSAMAKAN,
    label: 'Dokumen yang Dipersamakan dengan Faktur Pajak',
  },
  {
    value: DOKUMEN_TRANSAKSI.CUKAI_ROKOK,
    label: 'Cukai Rokok',
  },
  {
    value: DOKUMEN_TRANSAKSI.DOKUMEN_KAWASAN_BERIKAT,
    label: 'Dokumen Kawasan Berikat',
  },
  {
    value: DOKUMEN_TRANSAKSI.PEMBERITAHUAN_EKSPOR_BARANG,
    label: 'Pemberitahuan Ekspor Barang (PEB)',
  },
  {
    value: DOKUMEN_TRANSAKSI.PEMBERITAHUAN_EKSPOR_JASA,
    label: 'Pemberitahuan Ekspor BKP Tidak Berwujud / Pemberitahuan Ekspor JKP',
  },
  {
    value: DOKUMEN_TRANSAKSI.PEMBERITAHUAN_IMPOR_BAYAR,
    label: 'PIB dan SSP',
  },
  {
    value: DOKUMEN_TRANSAKSI.PEMBAYARAN,
    label: 'SSP',
  },
  {
    value: DOKUMEN_TRANSAKSI.DOKUMEN_TERTENTU,
    label: 'Dokumen Tertentu',
  },
  {
    value: DOKUMEN_TRANSAKSI.SKPKB_SKPKBT,
    label: 'SKPKB/SKPKBT atas JLN',
  },
  {
    value: DOKUMEN_TRANSAKSI.PEMBERITAHUAN_IMPOR,
    label: 'Pemberitahuan Impor',
  },
];

// helper aman untuk formatter / fallback
export const getDokumenTransaksiLabel = (value?: string) =>
  DOKUMEN_TRANSAKSI_OPTIONS.find((opt) => opt.value === value)?.label ?? value;
