import React, { useEffect, useRef } from 'react';
import Grid from '@mui/material/Grid';
import Divider from '@mui/material/Divider';
import { useFormContext, useWatch } from 'react-hook-form';
import { RHFNumeric } from 'src/components/hook-form/rhf-numeric';
import { KD_TRANSAKSI } from '../../constant';
import { useParams } from 'react-router';

interface TotalTransaksiProps {
  dlmData?: any; // data dari API
  isRetur?: boolean;
}

const TotalTransaksi: React.FC<TotalTransaksiProps> = ({ dlmData, isRetur }) => {
  const { control, setValue } = useFormContext<any>();
  const { type } = useParams<{ id?: string; type?: 'ubah' | 'pengganti' | 'new' }>();
  const isEditMode = type === 'ubah' || type === 'pengganti';

  const jumlahDpp = useWatch({ control, name: 'jumlahDpp' });

  const kdTransaksi = useWatch({ control, name: 'kdTransaksi' });

  const maxDpp = Number(dlmData?.returMaxDpp ?? 0);
  const maxPpn = Number(dlmData?.returMaxPpn ?? 0);
  const maxPpnbm = Number(dlmData?.returMaxPpnbm ?? 0);

  const isExport = kdTransaksi === KD_TRANSAKSI.EXPORT;

  console.log(maxPpnbm);
  useEffect(() => {
    // 🔒 EDIT / PENGGANTI → JANGAN SENTUH NILAI API
    if (isEditMode) return;

    // CREATE → AUTO HITUNG
    const dpp = Number(jumlahDpp || 0);
    const calculatedPpn = +(dpp * 0.12).toFixed(2);

    setValue('jumlahPpn', calculatedPpn, {
      shouldDirty: false,
      shouldTouch: false,
    });
  }, [isEditMode, isExport, jumlahDpp, setValue]);

  const prevDppRef = useRef<number | null>(null);

  useEffect(() => {
    prevDppRef.current = Number(jumlahDpp || 0);
  }, [jumlahDpp]);

  const dpp = Number(jumlahDpp || 0);
  const ppn = Number(useWatch({ control, name: 'jumlahPpn' }) || 0);
  const ppnbm = Number(useWatch({ control, name: 'jumlahPpnbm' }) || 0);

  // useEffect(() => {
  //   if (!isRetur) return;

  //   if (maxDpp && dpp > maxDpp) {
  //     setValue('jumlahDpp', maxDpp, { shouldDirty: true });
  //   }

  //   if (maxPpn && ppn > maxPpn) {
  //     setValue('jumlahPpn', maxPpn, { shouldDirty: true });
  //   }

  //   if (maxPpnbm && ppnbm > maxPpnbm) {
  //     setValue('jumlahPpnbm', maxPpnbm, { shouldDirty: true });
  //   }
  //   // eslint-disable-next-line react-hooks/exhaustive-deps
  // }, [isRetur, jumlahDpp, maxDpp, maxPpn, maxPpnbm]);

  useEffect(() => {
    if (!isRetur) return;

    if (maxDpp && dpp > maxDpp) {
      setValue('jumlahDpp', maxDpp, { shouldDirty: true });
    }

    if (maxPpn && ppn > maxPpn) {
      setValue('jumlahPpn', maxPpn, { shouldDirty: true });
    }

    if (maxPpnbm && ppnbm > maxPpnbm) {
      setValue('jumlahPpnbm', maxPpnbm, { shouldDirty: true });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isRetur, dpp, ppn, ppnbm, maxDpp, maxPpn, maxPpnbm]);

  const formatRupiah = (val: number) => val.toLocaleString('id-ID');

  return (
    <Grid container spacing={2} sx={{ mb: 3 }}>
      <Grid size={{ xs: 12 }} sx={{ mt: 3 }}>
        <Divider sx={{ fontWeight: 'bold', fontSize: '1rem', mb: 2 }} textAlign="left">
          Total Transaksi
        </Divider>
      </Grid>

      <Grid size={{ md: 4 }}>
        <RHFNumeric
          name="jumlahDpp"
          label="Jumlah DPP (Rp)"
          allowDecimalValue
          decimalScale={2}
          displayOnly={false}
          helperText={isRetur && maxDpp ? `Max Jumlah DPP : ${formatRupiah(maxDpp)}` : ''}
        />
      </Grid>

      <Grid size={{ md: 4 }}>
        {/* <RHFNumeric
          name="jumlahPpn"
          label="Jumlah PPN (Rp)"
          allowDecimalValue
          decimalScale={2}
          helperText={isRetur && maxPpn ? `Max Jumlah PPN : ${formatRupiah(maxPpn)}` : ''}
          onValueChange={() => {
            setValue('isPpnManual', true, { shouldDirty: false });
          }}
        /> */}
        <RHFNumeric
          name="jumlahPpn"
          label="Jumlah PPN (Rp)"
          allowDecimalValue
          decimalScale={2}
          helperText={isRetur && maxPpn ? `Max Jumlah PPN : ${formatRupiah(maxPpn)}` : ''}
          onValueChange={(values: any) => {
            if (!isRetur) return;

            const value = Number(values.floatValue || 0);

            if (maxPpn && value > maxPpn) {
              setValue('jumlahPpn', maxPpn, { shouldDirty: true });
              return;
            }

            setValue('jumlahPpn', value, { shouldDirty: true });
            setValue('isPpnManual', true, { shouldDirty: false });
          }}
        />
      </Grid>

      <Grid size={{ md: 4 }}>
        <RHFNumeric
          name="jumlahPpnbm"
          label="Jumlah PPnBM (Rp)"
          allowDecimalValue
          decimalScale={2}
          helperText={
            isRetur && maxPpnbm >= 0 ? `Max Jumlah PPnBM : ${formatRupiah(maxPpnbm)}` : ''
          }
          onValueChange={(values: any) => {
            if (!isRetur) return;

            const value = Number(values.floatValue || 0);

            if (maxPpnbm && value > maxPpnbm) {
              setValue('jumlahPpnbm', maxPpnbm, { shouldDirty: true });
              return;
            }

            setValue('jumlahPpnbm', value, { shouldDirty: true });
          }}
        />
      </Grid>
    </Grid>
  );
};

export default TotalTransaksi;
