import Grid from '@mui/material/Grid';
import type { Dayjs } from 'dayjs';
import dayjs from 'dayjs';
import { useEffect } from 'react';
import { useFormContext, useWatch } from 'react-hook-form';
import { Field } from 'src/components/hook-form';

type InfoReturProps = {
  minTanggalRetur?: Dayjs;
};

const InfoRetur = ({ minTanggalRetur }: InfoReturProps) => {
  const { control, setValue } = useFormContext();

  const tanggalRetur = useWatch({
    control,
    name: 'tanggalRetur',
  });

  useEffect(() => {
    if (!tanggalRetur) return;

    const d = dayjs(tanggalRetur);
    if (!d.isValid()) return;

    // 🔹 Tahun Pajak
    setValue('tahunPajakRetur', d.format('YYYY'));

    // 🔹 Masa Pajak (bulan)
    setValue('masaPajakRetur', d.format(), { shouldValidate: true });
  }, [tanggalRetur, setValue]);

  return (
    <Grid container spacing={2} sx={{ mb: 3 }}>
      <Grid sx={{ mt: 3 }} size={{ md: 6 }}>
        <Field.DatePicker
          name="tanggalRetur"
          label="Tanggal Retur"
          slotProps={{ textField: { helperText: '' } }}
          minDate={minTanggalRetur}
          maxDate={dayjs()}
          format="DD/MM/YYYY"
        />
      </Grid>

      <Grid sx={{ mt: 3 }} size={{ md: 3 }}>
        <Field.DatePicker
          name="tahunPajakRetur"
          label="Tahun Pajak"
          views={['year']}
          format="YYYY"
          disabled
        />
      </Grid>

      <Grid sx={{ mt: 3 }} size={{ md: 3 }}>
        <Field.DatePicker
          name="masaPajakRetur"
          label="Masa Pajak"
          views={['year', 'month']}
          openTo="month"
          format="MM"
          disabled
        />
      </Grid>

      <Grid size={{ md: 6 }}>
        <Field.Text name="nomorFakturDiretur" label="Nomor Faktur Direktur" disabled />
      </Grid>

      <Grid size={{ md: 6 }}>
        <Field.Text name="npwpPembeli" label="NPWP Penjual" disabled />
      </Grid>
    </Grid>
  );
};

export default InfoRetur;
