import { useMutation } from '@tanstack/react-query';
import dayjs from 'dayjs';
import type { TPostBupot26Request } from '../types/types';
import nrApi from '../utils/api';
import queryKey from '../../constant/queryKey';

const transformParams = ({ isPengganti = false, ...Data }: any): TPostBupot26Request => {
  const {
    id,
    idBupot,
    noBupot,
    npwpPemotong,
    idTku,
    masaPajak,
    tahunPajak,
    tinDipotong,
    namaDipotong,
    alamatDipotong,
    negaraDipotong,
    tglLahirDipotong,
    tmptLahirDipotong,
    nomorPaspor,
    nomorKitasKitap,
    fgFasilitas,
    noDokLainnya,
    kodeObjekPajak,
    pasalPph,
    statusPph,
    penghasilanBruto,
    normaPenghasilanNeto,
    tarif,
    pphDipotong,
    kap,
    kjs,
    metodePembayaranBendahara,
    nomorSP2D,
    tglPemotongan,
    userId,
    kanal,
    revNo: initialRevNo,
  } = Data;

  // Increment revNo kalau pengganti
  const revNo = isPengganti
    ? parseInt(initialRevNo?.toString() || '0', 10) + 1
    : parseInt(initialRevNo?.toString() || '0', 10);

  // Ambil NPWP dari localStorage kalau mau fallback
  const npwpLog = localStorage.getItem('npwp_log') ?? '';

  return {
    id: !isPengganti ? (id ?? null) : null,
    idBupot: idBupot ?? null,
    noBupot: noBupot ?? null,

    // Header-level Identitas
    npwpPemotong: npwpPemotong ?? npwpLog,
    idTku: idTku ?? '',
    masaPajak: masaPajak ? dayjs(masaPajak).format('MM') : '',
    tahunPajak: tahunPajak ? Number(dayjs(tahunPajak).format('YYYY')) : new Date().getFullYear(),

    // Data Wajib Pajak Dipotong
    tinDipotong: tinDipotong ?? '',
    namaDipotong: namaDipotong ?? '',
    alamatDipotong: alamatDipotong ?? '',
    negaraDipotong: negaraDipotong.value ?? '',
    tglLahirDipotong: tglLahirDipotong ? dayjs(tglLahirDipotong).format('DDMMYYYY') : '',
    tmptLahirDipotong: tmptLahirDipotong ?? '',
    nomorPaspor: nomorPaspor ?? '',
    nomorKitasKitap: nomorKitasKitap ?? '',

    // Fasilitas
    sertifikatInsentifDipotong: fgFasilitas.value ?? '9',
    nomorSertifikatInsentif: noDokLainnya ?? '',

    // Objek Pajak
    kodeObjekPajak: kodeObjekPajak.value ?? '',
    pasalPph: pasalPph ?? '',
    statusPph: statusPph ?? '',
    penghasilanBruto: Number(penghasilanBruto ?? 0),
    normaPenghasilanNeto: Number(normaPenghasilanNeto ?? 0),
    tarif: Number(tarif ?? 0),
    pphDipotong: Number(pphDipotong ?? 0),
    kap: Number(kap ?? 0),
    kjs: Number(kjs ?? 0),

    dokReferensi: (() => {
      const { namaDok, nomorDok, tglDok } = Data;
      // pastikan tidak undefined dan tanggal valid
      if (!namaDok || !nomorDok || !tglDok) return [];

      const parsedDate = dayjs(tglDok);
      const tanggalFormatted = parsedDate.isValid() ? parsedDate.format('DDMMYYYY') : '';

      if (!tanggalFormatted) return [];

      return [
        {
          dokReferensi: namaDok.value,
          nomorDokumen: nomorDok,
          tanggal_Dokumen: tanggalFormatted,
        },
      ];
    })(),

    metodePembayaranBendahara: metodePembayaranBendahara ?? '',
    nomorSP2D: nomorSP2D ?? '',
    tglPemotongan: tglPemotongan ? dayjs(tglPemotongan).format('DDMMYYYY') : '',
    userId: userId ?? '',
    kanal: kanal ?? '',
    revNo,
    feature: '26'
  };
};

const useSave = (props?: any) =>
  useMutation({
    mutationKey: queryKey.bupot26.draft,
    mutationFn: (params: any) => nrApi.save(transformParams(params)),
    ...props,
  });

export default useSave;
