import { useMutation, type UseMutationOptions } from '@tanstack/react-query';
import queryKey from 'src/sections/bupot-21-26/constant/queryKey';
import tahunanA1Api from '../utils/api';
import type{ TPortBulananCenceledRequest } from '../types/types';

const useCencelBulanan = (
  props?: Omit<
    UseMutationOptions<any, Error, TPortBulananCenceledRequest, unknown>,
    'mutationKey' | 'mutationFn'
  >
) =>
  useMutation<any, Error, TPortBulananCenceledRequest, unknown>({
    mutationKey: queryKey.tahunanA1.upload,
    mutationFn: (params: TPortBulananCenceledRequest) => tahunanA1Api.batal(params),
    ...props,
  });

export default useCencelBulanan;
