// ============================================
// CONSTANTS & CONFIGURATION
// ============================================

import { FG_PERHITUNGAN } from "../../constant";

// Field Names Mapping
const FORM_FIELDS = {
  // Data Penghasilan Setahun
  GAJI: 'rincian1',
  TUNJANGAN_PPH: 'rincian2',
  TUNJANGAN_LAINNYA: 'rincian3',
  HONORARIUM: 'rincian4',
  PREMI_ASURANSI: 'rincian5',
  NATURA: 'rincian6',
  TANTIEM_BONUS: 'rincian7',
  JUMLAH_BRUTO: 'rincian8',
  
  // Pengurangan
  BIAYA_JABATAN: 'rincian9',
  IURAN_PENSIUN: 'rincian10',
  ZAKAT: 'rincian11',
  JUMLAH_PENGURANGAN: 'rincian12',
  
  // Penghitungan PPh Pasal 21
  PENGHASILAN_NETO: 'rincian13',
  PENGHASILAN_NETO_SEBELUMNYA: 'rincian14',
  JUMLAH_PENGHASILAN_NETO: 'rincian15',
  PTKP: 'rincian16',
  PENGHASILAN_KENA_PAJAK: 'rincian17',
  PPH_ATAS_PKP: 'rincian18',
  PPH_TERUTANG: 'rincian19',
  PPH_DIPOTONG_SEBELUMNYA: 'rincian20',
  PPH_TERUTANG_BUKTI_INI: 'rincian21',
  PPH_DIPOTONG_DITANGGUNG: 'rincian22',
  PPH_KURANG_LEBIH: 'rincian23',
};

// Section Configuration
const FORM_SECTIONS = {
  PENGHASILAN: {
    title: 'DATA PENGHASILAN SETAHUN',
    startNumber: 1,
    fields: [
      'GAJI ATAU UANG PENSIUNAN BERKALA',
      'TUNJANGAN PPh',
      'TUNJANGAN LAINNYA, UANG LEMBUR DAN SEGALANYA',
      'HONORARIUM DAN IMBALAN LAIN SEJENISNYA',
      'PREMI ASURANSI YANG DIBAYARKAN PEMBERI KERJA',
      'PENERIMAAN DALAM BENTUK NATURA DAN KENIKMATAN LAINNYA YANG DIKENAKAN PEMOTONGAN PPh PASAL 21',
      'TANTIEM, BONUS, GRATIFIKASI, JASA PRODUKSI DAN THR',
      'JUMLAH PENGHASILAN BRUTO (1 S.D. 7)',
    ],
  },
  PENGURANGAN: {
    title: 'PENGURANGAN',
    startNumber: 9,
    fields: [
      'BIAYA JABATAN/BIAYA PENSIUN',
      'IURAN TERKAIT PENSIUN ATAU HARI TUA',
      'ZAKAT/SUMBANGAN KEAGAMAAN YANG BERSIFAT WAJIB YANG DIBAYARKAN MELALUI PEMBERI KERJA',
      'JUMLAH PENGURANGAN (9 S.D. 11)',
    ],
  },
  PENGHITUNGAN: {
    title: 'PENGHITUNGAN PPh PASAL 21',
    startNumber: 13,
    fields: [
      'JUMLAH PENGHASILAN NETO (8 - 12)',
      'PENGHASILAN NETO DARI PEMOTONGAN SEBELUMNYA',
      'JUMLAH PENGHASILAN NETO UNTUK PERHITUNGAN PPh PASAL 21 (SETAHUN/DISETAHUNKAN)',
      'PENGHASILAN TIDAK KENA PAJAK (PTKP)',
      'PENGHASILAN KENA PAJAK SETAHUN/DISETAHUNKAN (15 - 16)',
      'PPh PASAL 21 ATAS PENGHASILAN KENA PAJAK SETAHUN/DISETAHUNKAN',
      'PPh PASAL 21 TERUTANG',
      'PPh PASAL 21 DIPOTONG DARI BUKTI PEMOTONGAN SEBELUMNYA',
      'PPh PASAL 21 TERUTANG PADA BUKTI PEMOTONGAN INI (DAPAT DIKREDITKAN PADA SPT TAHUNAN)',
      'PPh PASAL 21 YANG TELAH DIPOTONG/DITANGGUNG PEMERINTAH',
      'PPh PASAL 21 KURANG (LEBIH) DIPOTONG PADA MASA PAJAK DESEMBER/MASA PAJAK TERAKHIR (21 - 22)',
    ],
  },
};

// Calculated/ReadOnly Fields
const CALCULATED_FIELDS = new Set([
  FORM_FIELDS.JUMLAH_BRUTO,
  FORM_FIELDS.BIAYA_JABATAN,
  FORM_FIELDS.JUMLAH_PENGURANGAN,
  FORM_FIELDS.PENGHASILAN_NETO,
  FORM_FIELDS.PENGHASILAN_NETO_SEBELUMNYA,
  FORM_FIELDS.JUMLAH_PENGHASILAN_NETO,
  FORM_FIELDS.PTKP,
  FORM_FIELDS.PENGHASILAN_KENA_PAJAK,
  FORM_FIELDS.PPH_ATAS_PKP,
  FORM_FIELDS.PPH_TERUTANG,
  FORM_FIELDS.PPH_DIPOTONG_SEBELUMNYA,
  FORM_FIELDS.PPH_TERUTANG_BUKTI_INI,
  FORM_FIELDS.PPH_KURANG_LEBIH,
]);


// ============================================
// HELPER FUNCTIONS
// ============================================

const isFieldReadOnly = (fieldName: string, msPjkAwal: number,  isMetodePemotonganSeTahun: any ,fgPerhitungan: string) => {

  // Calculated fields are always readonly
  if (CALCULATED_FIELDS.has(fieldName)) {
    return true;
  }
  
  
  // Special case: Tunjangan PPh
  if (fieldName === FORM_FIELDS.TUNJANGAN_PPH) {
    console.log("🚀 ~ isFieldReadOnly:",{ msPjkAwal, isMetodePemotonganSeTahun});
    return fgPerhitungan === FG_PERHITUNGAN.GROSS_UP;
  }
  
  if (fieldName === FORM_FIELDS.PENGHASILAN_NETO_SEBELUMNYA) {
    return msPjkAwal >= 2 && isMetodePemotonganSeTahun !==  '1'
  }
  // If PPh21 is active, all input fields are readonly
  return false;
};

const getFieldNameByIndex = (index: any) => {
  const fieldNames = Object.values(FORM_FIELDS);
  return fieldNames[index] || `rincian${index + 1}`;
};

const perhitunganA1List = Object.values(FORM_FIELDS).map(values=>({[values]:0}))

export {
    FORM_FIELDS, 
    FORM_SECTIONS,
    CALCULATED_FIELDS,
    isFieldReadOnly,
    getFieldNameByIndex,
    perhitunganA1List,
}
