import { isEmpty } from 'lodash';
import { FG_PDF_STATUS, FG_SIGN_STATUS } from '../constant';
import { useQuery } from '@tanstack/react-query';
import queryKey from '../constant/queryKey';
import type {
  TBaseResponseAPI,
  TGetListDataTableDn,
  TGetListDataTableDnResult,
} from '../types/types';
import bulananApi from '../utils/api';

export const transformFgStatusToFgSignStatus = (fgStatus: any) => {
  console.log('🚀 ~ transformFgStatusToFgSignStatus ~ fgStatus:', fgStatus);
  const splittedFgStatus = fgStatus?.split('-') || [];

  if (splittedFgStatus.includes('SIGN') > 0) {
    // failed
    return FG_SIGN_STATUS.FAILED;
  }

  if (splittedFgStatus.includes('SIGNING IN PROGRESS')) {
    return FG_SIGN_STATUS.IN_PROGRESS;
  }
  if (fgStatus === 'DUPLICATE') {
    return FG_SIGN_STATUS.DUPLICATE;
  }
  if (fgStatus === 'NOT_MATCH_STATUS') {
    return FG_SIGN_STATUS.NOT_MATCH_STATUS;
  }
  if (fgStatus === 'NOT_MATCH_NILAI') {
    return FG_SIGN_STATUS.NOT_MATCH_NILAI;
  }
  if (fgStatus === 'NOT_MATCH_IDBUPOT') {
    return FG_SIGN_STATUS.NOT_MATCH_IDBUPOT;
  }

  switch (splittedFgStatus[1]) {
    case 'document signed successfully':
    case 'Done':
      return FG_SIGN_STATUS.SIGNED;
    case 'SIGNING_IN_PROGRESS':
      return FG_SIGN_STATUS.IN_PROGRESS;
    case 'DUPLICATE':
      return FG_SIGN_STATUS.DUPLICATE;
    case 'NOT_MATCH_STATUS':
      return FG_SIGN_STATUS.NOT_MATCH_STATUS;
    case 'NOT_MATCH_IDBUPOT':
      return FG_SIGN_STATUS.NOT_MATCH_IDBUPOT;
    default:
      return null;
  }
};

export const getFgStatusPdf = (link: any, fgSignStatus: any) => {
  if (isEmpty(link) || [FG_SIGN_STATUS.IN_PROGRESS].includes(fgSignStatus))
    return FG_PDF_STATUS.TIDAK_TERSEDIA;

  if (!link.includes('https://coretaxdjp.pajak.go.id/')) return FG_PDF_STATUS.BELUM_TERBENTUK;

  return FG_PDF_STATUS.TERBENTUK;
};

export const transformSortModelToSortApiPayload = (transformedModel: any) => ({
  sortingMode: transformedModel.map((item: any) => item.field).join(','),
  sortingMethod: transformedModel.length > 0 ? transformedModel[0].sort : 'desc',
});

const normalisePropsGetDn = (params: TGetListDataTableDn) => ({
  ...params,
  nomorSP2D: params.dokumen_referensi?.[0]?.nomorSP2D || '',
  metodePembayaranBendahara: params.dokumen_referensi?.[0]?.metodePembayaranBendahara || '',
  dokReferensi: params.dokumen_referensi?.[0]?.dokReferensi || '',
  nomorDokumen: params.dokumen_referensi?.[0]?.nomorDokumen || '',
  id: params.id,
  npwpPemotong: params.npwpPemotong,
  idBupot: params.idBupot,
  internal_id: params.internal_id,
  // fgStatus: FG_STATUS[params.fgStatus],
  fgStatus: params.fgStatus,
  fgSignStatus: transformFgStatusToFgSignStatus(params.fgStatus),
  fgPdf: getFgStatusPdf(params.link, transformFgStatusToFgSignStatus(params.fgStatus)),
  fgLapor: params.fgLapor,
  revNo: params.revNo,
  thnPajak: params.tahunPajak,
  msPajak: params.masaPajak,
  kdObjPjk: params.kodeObjekPajak,
  noBupot: params.noBupot,
  idDipotong: params.userId,
  glAccount: params.glAccount,
  namaDipotong: params.nama,
  jmlBruto: params.dpp,
  pphDipotong: params.pphDipotong,
  created: params.created_by,
  fgKirimEmail: params.fgkirimemail,
  created_at: params.created_at,
  updated: params.updated_by,
  updated_at: params.updated_at,
});

const normalisPropsParmasGetDn = (params: any) => {
  const sorting = !isEmpty(params.sort) ? transformSortModelToSortApiPayload(params.sort) : {};

  return {
    ...params,
    page: params.Page,
    limit: params.Limit,
    masaPajak: params.msPajak || null,
    tahunPajak: params.thnPajak || null,
    npwp: params.idDipotong || null,
    advanced: isEmpty(params.advanced) ? undefined : params.advanced,
    ...sorting,
  };
};
const useGetBulanan = ({ params, ...props }: any) => {
  const query = useQuery<TBaseResponseAPI<TGetListDataTableDnResult>>({
    queryKey: queryKey.bulanan.all(params),
    queryFn: async () => {
      const response = await bulananApi.getBulanan({ params: normalisPropsParmasGetDn(params) });

      return {
        ...response,
        // data: response.data.map((data) => normalisePropsGetDn(data)),
      };
    },
    initialData: {
      data: [],
      total: 0,
    },
    refetchOnWindowFocus: false,
    ...props,
  });

  return query;
};

export default useGetBulanan;
