import Divider from '@mui/material/Divider';
import Grid from '@mui/material/Grid';
import { useMemo } from 'react';
import { useFormContext } from 'react-hook-form';
import { Field } from 'src/components/hook-form';
import { FG_FASILITAS_PPH_21, FG_FASILITAS_PPH_21_TEXT } from '../../constant';

type PPHDipotongProps = {
  kodeObjectPajak: {
    value: string;
    label: string;
  }[];
};

const PerhitunganPPhPasal21 = ({ kodeObjectPajak }: PPHDipotongProps) => {
  const { watch } = useFormContext();

  const fgFasilitas = watch('fgFasilitas');

  const fgFasilitasOptions = useMemo(
    () =>
      [
        FG_FASILITAS_PPH_21.DTP,
        FG_FASILITAS_PPH_21.FASILITAS_LAINNYA,
        FG_FASILITAS_PPH_21.TANPA_FASILITAS,
      ].map((value) => ({
        value,
        label: FG_FASILITAS_PPH_21_TEXT[value],
      })),
    []
  );

  return (
    <Grid container rowSpacing={2} columnSpacing={2}>
      {/* Divider */}
      <Grid size={{ md: 12 }}>
        <Divider sx={{ fontWeight: 'bold' }} textAlign="left">
          Perhitungan PPh Pasal 21
        </Divider>
      </Grid>

      {/* Kode objek pajak */}
      <Grid size={{ md: 12 }}>
        <Field.Autocomplete name="kdObjPjk" label="Kode Objek Pajak" options={kodeObjectPajak} />
      </Grid>

      {/* Fasilitas */}
      <Grid size={{ md: 6 }}>
        <Field.Autocomplete name="fgFasilitas" label="Fasilitas" options={fgFasilitasOptions} />
      </Grid>

      {/* Dokumen lainnya */}
      <Grid size={{ md: 6 }}>
        <Field.Text
          name="noDokLainnya"
          label="Nomor Dokumen Lainnya"
          disabled={['9', ''].includes(fgFasilitas)}
          sx={{ '& .MuiInputBase-root.Mui-disabled': { backgroundColor: '#f6f6f6' } }}
        />
      </Grid>
    </Grid>
  );
};

export default PerhitunganPPhPasal21;
