import React from 'react';
import Chip from '@mui/material/Chip';
import Box from '@mui/material/Box';

type Props = { value?: string; revNo?: number };

const StatusChip: React.FC<Props> = ({ value, revNo }) => {
  if (!value) return <Chip label="" size="small" />;

  if (value === 'NORMAL-Done' && `${revNo}` !== "0") {
    return (
      <Box
        sx={{
          position: 'relative',
          display: 'inline-flex',
          alignItems: 'center',
        }}
      >
        <Chip
          label="Normal Pengganti"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#1976d2',
            color: '#1976d2',
            borderRadius: '8px',
            fontWeight: 500,
            paddingRight: '5px',
          }}
        />

        <Chip
          label={revNo}
          size="small"
          variant="filled"
          sx={{
            position: 'absolute',
            top: -6,
            right: -6,
            backgroundColor: '#1976d2',
            color: '#fff',
            borderRadius: '50%',
            fontWeight: 500,
            width: 18,
            height: 18,
            minWidth: 0,
            border: '2px solid #fff',
            boxShadow: '0 1px 3px rgba(0, 0, 0, 0.25)',
            '& .MuiChip-label': {
              padding: 0,
              fontSize: '0.65rem',
              lineHeight: 1,
            },
          }}
        />
      </Box>
    );
  }
  if (value === 'NORMAL-Done' && revNo === 0) {
    return (
      <Chip
        label="Normal"
        size="small"
        variant="outlined"
        sx={{
          borderColor: '#1976d2',
          color: '#1976d2',
          borderRadius: '8px',
          fontWeight: '500',
        }}
      />
    );
  }

  if (value === 'AMENDED') {
    return (
      <Chip
        label="Diganti"
        size="small"
        variant="outlined"
        sx={{
          color: '#fff',
          backgroundColor: '#f38c28',
          borderRadius: '8px',
          fontWeight: 500,
          border: 'none',
          boxShadow: '0 1px 2px rgba(0, 0, 0, 0.15)',
        }}
      />
    );
  }

  if (value === 'CANCELLED') {
    return (
      <Chip
        label="Dibatalkan"
        size="small"
        variant="outlined"
        sx={{
          borderColor: '#d32f2f',
          color: '#d32f2f',
          borderRadius: '8px',
          fontWeight: '500',
        }}
      />
    );
  }

  if (value === 'DRAFT') {
    return (
      <Chip
        label="Draft"
        size="small"
        variant="outlined"
        sx={{
          borderColor: '#9e9e9e',
          color: '#616161',
          borderRadius: '8px',
        }}
      />
    );
  }

  return <Chip label={value} size="small" />;
};

export default React.memo(StatusChip);
