import { useMutation } from '@tanstack/react-query';
import type { TDeleteRequest } from '../types/types';
import fakturApi from '../utils/api';

const useDeleteReturPM = (props?: any) =>
  useMutation<any, Error, TDeleteRequest>({
    mutationKey: ['delete-retur-pm'],
    mutationFn: (payload) => fakturApi.deleteReturPM(payload),
    ...props,
  });

export default useDeleteReturPM;
