import dayjs from 'dayjs';

/**
 * Format date utility function using Day.js
 * @param {string | Date | dayjs.Dayjs} date - Date to format
 * @param {string} formatStr - Format string (e.g., 'YYYY-MM', 'YYYY')
 * @returns {string} Formatted date string
 */
const formatDate = (date: string | Date, formatStr: string) => {
  if (!date) return '';
  
  try {
    const dayjsObj = dayjs(date);
    
    if (!dayjsObj.isValid()) {
      console.error('Invalid date:', date);
      return '';
    }
    
    return dayjsObj.format(formatStr);
  } catch (error) {
    console.error('Error formatting date:', error);
    return '';
  }
};

/**
 * Helper function to get year from date
 * @param {string | Date} date - Date
 * @returns {number} Year
 */
const getTahunPajak = (date: string | Date) => {
  if (!date) return 0;
  return dayjs(date).year();
};

export {
    formatDate, getTahunPajak
}