import { useMutation } from '@tanstack/react-query';
import dayjs from 'dayjs';
import dnApi from '../utils/api';
import type { TPostDnRequest } from '../types/types';

const transformParams = ({ isPengganti = false, ...dnData }: any): TPostDnRequest => {
  const {
    id,
    idBupot,
    noBupot,
    msPajak,
    thnPajak,
    idDipotong,
    nitku,
    namaDipotong,
    fgFasilitas,
    noDokLainnya,
    kdObjPjk,
    kdJnsPjk,
    statusPph,
    jmlBruto,
    tarif,
    pphDipotong,
    kap,
    kjs,
    revNo: initialRevNo,
    tglPemotongan,
    namaDok,
    nomorDok,
    tglDok,
    metodePembayaranBendahara,
    nomorSP2D,
    idTku,
    email,
    glAccount,
    keterangan1,
    keterangan2,
    keterangan3,
    keterangan4,
    keterangan5,
  } = dnData;

  const dokReferensi = [
    {
      dokReferensi: namaDok || '',
      nomorDokumen: nomorDok || '',
      tanggal_Dokumen: tglDok ? dayjs(tglDok).format('DDMMYYYY') : '',
      metodePembayaranBendahara: metodePembayaranBendahara || '',
      nomorSP2D: nomorSP2D || '',
    },
  ];

  const revNo = isPengganti ? parseInt(initialRevNo || 0, 10) + 1 : parseInt(initialRevNo || 0, 10);

  const npwpLog = localStorage.getItem('npwp_log') ?? '';

  return {
    id: !isPengganti ? (id ?? null) : null,
    idBupot: idBupot ?? null,
    noBupot: noBupot ?? null,
    npwpPemotong: npwpLog,
    idTku: idTku ?? '',
    masaPajak: msPajak ? dayjs(msPajak).format('MM') : '',
    tahunPajak: thnPajak ? Number(dayjs(thnPajak).format('YYYY')) : 0,
    npwp: idDipotong ?? '',
    nik: nitku ?? (idDipotong ? `${idDipotong}000000` : ''),
    nama: namaDipotong ?? '',
    revNo,
    fgNpwpNik: 'true', // static
    fgJnsBupot: 'BPU', // static
    dataDetilBpu: {
      sertifikatInsentifDipotong: fgFasilitas ?? '9',
      nomorSertifikatInsentif: noDokLainnya ?? '',
      kodeObjekPajak: kdObjPjk ?? '',
      pasalPPh: kdJnsPjk ?? '',
      statusPPh: statusPph ?? '',
      dpp: jmlBruto ?? '',
      tarif: tarif ?? '',
      pphDipotong: pphDipotong ?? '',
      kap: kap ?? '',
      kjs: kjs ?? '',
      dokReferensi,
    },
    tglPemotongan: tglPemotongan ? dayjs(tglPemotongan).format('DDMMYYYY') : '',
    email: email ?? '',
    glAccount: glAccount ?? '',
    keterangan1: keterangan1 ?? '',
    keterangan2: keterangan2 ?? '',
    keterangan3: keterangan3 ?? '',
    keterangan4: keterangan4 ?? '',
    keterangan5: keterangan5 ?? '',
  };
};

const useSaveDn = (props?: any) =>
  useMutation({
    mutationKey: ['Save-Dn'],
    mutationFn: (params: any) => dnApi.saveDn(transformParams(params)),
    ...props,
  });

export default useSaveDn;
