// hooks/useUpload.ts
import { useMutation } from '@tanstack/react-query';
import nrApi from '../utils/api';

const useUpload = (props?: any) =>
  useMutation({
    mutationKey: ['upload-nr'],
    mutationFn: (payload: { id: string | number }) => nrApi.upload(payload),
    ...props,
  });

export default useUpload;
