import type { NavSectionProps } from 'src/components/nav-section';

import { paths } from 'src/routes/paths';

import { CONFIG } from 'src/global-config';

import { SvgColor } from 'src/components/svg-color';

// ----------------------------------------------------------------------

const icon = (name: string) => (
  <SvgColor src={`${CONFIG.assetsDir}/assets/icons/navbar/${name}.svg`} />
);

const ICONS = {
  job: icon('ic-job'),
  blog: icon('ic-blog'),
  chat: icon('ic-chat'),
  mail: icon('ic-mail'),
  user: icon('ic-user'),
  file: icon('ic-file'),
  lock: icon('ic-lock'),
  tour: icon('ic-tour'),
  order: icon('ic-order'),
  label: icon('ic-label'),
  blank: icon('ic-blank'),
  kanban: icon('ic-kanban'),
  folder: icon('ic-folder'),
  course: icon('ic-course'),
  params: icon('ic-params'),
  banking: icon('ic-banking'),
  booking: icon('ic-booking'),
  invoice: icon('ic-invoice'),
  product: icon('ic-product'),
  calendar: icon('ic-calendar'),
  disabled: icon('ic-disabled'),
  external: icon('ic-external'),
  subpaths: icon('ic-subpaths'),
  menuItem: icon('ic-menu-item'),
  ecommerce: icon('ic-ecommerce'),
  analytics: icon('ic-analytics'),
  dashboard: icon('ic-dashboard'),

  // unifikasi: <Iconify icon="mdi:file-document" width={24} />,
};

// ----------------------------------------------------------------------

/**
 * Input nav data is an array of navigation section items used to define the structure and content of a navigation bar.
 * Each section contains a subheader and an array of items, which can include nested children items.
 *
 * Each item can have the following properties:
 * - `title`: The title of the navigation item.
 * - `path`: The URL path the item links to.
 * - `icon`: An optional icon component to display alongside the title.
 * - `info`: Optional additional information to display, such as a label.
 * - `allowedRoles`: An optional array of roles that are allowed to see the item.
 * - `caption`: An optional caption to display below the title.
 * - `children`: An optional array of nested navigation items.
 * - `disabled`: An optional boolean to disable the item.
 * - `deepMatch`: An optional boolean to indicate if the item should match subpaths.
 */
export const navData: NavSectionProps['data'] = [
  /**
   * Overview
   */
  {
    subheader: 'Overview',
    items: [{ title: 'Beranda', path: paths.dashboard.root, icon: ICONS.dashboard }],
  },
  /**
   * Management
   */
  {
    subheader: '',
    items: [
      {
        title: 'e-Bupot Unifikasi',
        path: paths.unifikasi.dn,
        icon: ICONS.blank,
        children: [
          { title: 'Bupot Unifikasi', path: paths.unifikasi.dn },
          { title: 'Bupot Non Residen', path: paths.unifikasi.nr },
          { title: 'Bupot Disetor Sendiri', path: paths.unifikasi.ssp },
          { title: 'Bupot Digunggung', path: paths.unifikasi.digunggung },
          { title: 'Dokumen Dipersamakan', path: paths.unifikasi.dipersamakan },
        ],
      },
    ],
  },
  {
    subheader: '',
    items: [
      {
        title: 'e-Bupot 21/26',
        path: paths.pph21.bulanan,
        icon: ICONS.blank,
        children: [
          { title: 'Bupot Bulanan', path: paths.pph21.bulanan },
          { title: 'Bupot Final/Tidak Final', path: paths.pph21.bupotFinal },
          { title: 'Bupot Tahunan A1', path: paths.pph21.tahunan },
          { title: 'Bupot Pasal 26', path: paths.pph21.bupot26 },
        ],
      },
    ],
  },
  {
    subheader: '',
    items: [
      {
        title: 'e-Faktur',
        path: paths.faktur.pk,
        icon: ICONS.blank,
        children: [
          {
            title: 'Faktur',
            path: paths.faktur.pk,
            children: [
              { title: 'Pajak Keluaran', path: paths.faktur.pk },
              { title: 'Pajak Masukan', path: paths.faktur.pm },
              { title: 'Retur Pajak Keluaran', path: paths.faktur.returPk },
              { title: 'Retur Pajak Masukan', path: paths.faktur.returPm },
            ],
          },
          {
            title: 'Dokumen Lain',
            path: paths.faktur.dlk,
            children: [
              { title: 'Dokumen Lain Keluaran', path: paths.faktur.dlk },
              { title: 'Dokumen Lain Masukan', path: paths.faktur.dlm },
              { title: 'Retur Dokumen Lain Keluaran', path: paths.faktur.returDlk },
              { title: 'Retur Dokumen Lain Masukan', path: paths.faktur.returDlm },
            ],
          },
        ],
      },
    ],
  },
];

/**
 * Permissions can be set for each item by using the `allowedRoles` property.
 * - If `allowedRoles` is not set (default), all roles can see the item.
 * - If `allowedRoles` is an empty array `[]`, no one can see the item.
 * - If `allowedRoles` contains specific roles, only those roles can see the item.
 *
 * Examples:
 * - `allowedRoles: ['user']` - only users with the 'user' role can see this item.
 * - `allowedRoles: ['admin']` - only users with the 'admin' role can see this item.
 * - `allowedRoles: ['admin', 'manager']` - only users with the 'admin' or 'manager' roles can see this item.
 *
 * Combine with the `checkPermissions` prop to build conditional expressions.
 * Example usage can be found in: src/sections/_examples/extra/navigation-bar-view/nav-vertical.{jsx | tsx}
 */
