import type { RouteObject } from 'react-router';

import { lazy, Suspense } from 'react';
import { Outlet } from 'react-router';

import { CONFIG } from 'src/global-config';
import { DashboardLayout } from 'src/layouts/dashboard';

import { LoadingScreen } from 'src/components/loading-screen';

import { AccountLayout } from 'src/sections/account/account-layout';

import { AuthGuard } from 'src/auth/guard';

import { usePathname } from '../hooks';

// ----------------------------------------------------------------------

// Unifikasi
const OverviewUnifikasiDnPage = lazy(() => import('src/pages/unifikasi/unifikasiDn'));
const OverviewUnifikasiRekamDnPage = lazy(() => import('src/pages/unifikasi/unifikasiRekamDn'));

const OverviewUnifikasiNrPage = lazy(() => import('src/pages/unifikasi/unifikasiNr'));
const OverviewUnifikasiRekamNrPage = lazy(() => import('src/pages/unifikasi/unifikasiRekamNr'));

const OverviewUnifikasiSspPage = lazy(() => import('src/pages/unifikasi/unifikasiSsp'));
const OverviewUnifikasiRekamSspPage = lazy(() => import('src/pages/unifikasi/unifikasiRekamSsp'));

const OverviewUnifikasiDigunggungPage = lazy(
  () => import('src/pages/unifikasi/unifikasiDigunggung')
);
const OverviewUnifikasiRekamDigunggungPage = lazy(
  () => import('src/pages/unifikasi/unifikasiRekamDigunggung')
);

const OverviewUnifikasiDokumenDipersamakanPage = lazy(
  () => import('src/pages/unifikasi/unifikasiDokumenDipersamakan')
);
const OverviewUnifikasiRekamDokumenDipersamakanPage = lazy(
  () => import('src/pages/unifikasi/unifikasiRekamDokumenDipersamakan')
);
// Overview
const IndexPage = lazy(() => import('src/pages/dashboard'));

// User
const UserProfilePage = lazy(() => import('src/pages/dashboard/user/profile'));
const UserCardsPage = lazy(() => import('src/pages/dashboard/user/cards'));
const UserListPage = lazy(() => import('src/pages/dashboard/user/list'));
const UserCreatePage = lazy(() => import('src/pages/dashboard/user/new'));
const UserEditPage = lazy(() => import('src/pages/dashboard/user/edit'));

// Account
const AccountGeneralPage = lazy(() => import('src/pages/dashboard/user/account/general'));
const AccountChangePasswordPage = lazy(
  () => import('src/pages/dashboard/user/account/change-password')
);

// Bupot 21/26
const OverviewBupotBulananPage = lazy(() => import('src/pages/pph21/bupotBulanan'));
const OverviewBupotBulananRekamPage = lazy(() => import('src/pages/pph21/bupotBulananRekam'));
const OverviewBupotFinalTdkFinalPage = lazy(() => import('src/pages/pph21/bupotFinaltidakFinal'));
const OverviewBupotA1Page = lazy(() => import('src/pages/pph21/bupoTahunanA1'));
const OverviewBupotPasal26Page = lazy(() => import('src/pages/pph21/bupotPasal26'));

// ----------------------------------------------------------------------

function SuspenseOutlet() {
  const pathname = usePathname();
  return (
    <Suspense key={pathname} fallback={<LoadingScreen />}>
      <Outlet />
    </Suspense>
  );
}

const dashboardLayout = () => (
  <DashboardLayout>
    <SuspenseOutlet />
  </DashboardLayout>
);

const accountLayout = () => (
  <AccountLayout>
    <SuspenseOutlet />
  </AccountLayout>
);

export const dashboardRoutes: RouteObject[] = [
  {
    path: 'dashboard',
    element: CONFIG.auth.skip ? dashboardLayout() : <AuthGuard>{dashboardLayout()}</AuthGuard>,
    children: [
      { index: true, element: <IndexPage /> },
      {
        path: 'user',
        children: [
          { index: true, element: <UserProfilePage /> },
          { path: 'profile', element: <UserProfilePage /> },
          { path: 'cards', element: <UserCardsPage /> },
          { path: 'list', element: <UserListPage /> },
          { path: 'new', element: <UserCreatePage /> },
          { path: ':id/edit', element: <UserEditPage /> },
          {
            path: 'account',
            element: accountLayout(),
            children: [
              { index: true, element: <AccountGeneralPage /> },
              { path: 'change-password', element: <AccountChangePasswordPage /> },
            ],
          },
        ],
      },
    ],
  },
  {
    path: 'unifikasi',
    element: CONFIG.auth.skip ? dashboardLayout() : <AuthGuard>{dashboardLayout()}</AuthGuard>,
    children: [
      { index: true, element: <OverviewUnifikasiDnPage /> },
      { path: 'dn', element: <OverviewUnifikasiDnPage /> },
      { path: 'dn/new', element: <OverviewUnifikasiRekamDnPage /> },
      { path: 'dn/:id/:type', element: <OverviewUnifikasiRekamDnPage /> },
      { path: 'nr', element: <OverviewUnifikasiNrPage /> },
      { path: 'nr/new', element: <OverviewUnifikasiRekamNrPage /> },
      { path: 'ssp', element: <OverviewUnifikasiSspPage /> },
      { path: 'ssp/new', element: <OverviewUnifikasiRekamSspPage /> },
      { path: 'digunggung', element: <OverviewUnifikasiDigunggungPage /> },
      { path: 'digunggung/new', element: <OverviewUnifikasiRekamDigunggungPage /> },
      { path: 'dokumen-dipersamakan', element: <OverviewUnifikasiDokumenDipersamakanPage /> },
      {
        path: 'dokumen-dipersamakan/new',
        element: <OverviewUnifikasiRekamDokumenDipersamakanPage />,
      },
    ],
  },
  {
    path: 'pph21',
    element: CONFIG.auth.skip ? dashboardLayout() : <AuthGuard>{dashboardLayout()}</AuthGuard>,
    children: [
      { index: true, element: <OverviewBupotBulananPage /> },
      { path: 'bulanan', element: <OverviewBupotBulananPage /> },
      { path: 'bulanan/rekam', element: <OverviewBupotBulananRekamPage /> },
      { path: 'bulanan/:id/:type', element: <OverviewBupotBulananRekamPage /> },
      { path: 'bupot-final', element: <OverviewBupotFinalTdkFinalPage /> },
      { path: 'tahunan', element: <OverviewBupotA1Page /> },
      { path: 'bupot-26', element: <OverviewBupotPasal26Page /> },
    ],
  },
];
