import { useMutation } from '@tanstack/react-query';
import dayjs from 'dayjs';
import { enqueueSnackbar } from 'notistack';
import fakturApi from '../utils/api';

interface UseReturProps {
  dlkData: any;
  onSuccess?: () => void;
}

export const useReturDokumenLainKeluaran = ({ dlkData, onSuccess }: UseReturProps) =>
  useMutation({
    mutationFn: async (values: any) => {
      const num = (v: any) => Number(String(v ?? 0).replace(/,/g, '')) || 0;

      const payload = {
        kdTransaksi: values.kdTransaksi ?? dlkData.kdtransaksi,
        detailTransaksi: values.detailTransaksi ?? dlkData.detailtransaksi,
        dokumenTransaksi: values.dokumenTransaksi ?? dlkData.dokumentransaksi,

        npwpPembeli: values.npwpPembeli ?? dlkData.npwppembeli,
        namaPembeli: values.namaPembeli ?? dlkData.namapembeli,

        nomorDokumenRetur: values.nomorDokumenRetur,
        nomorRetur: values.nomorRetur,

        tanggalRetur: dayjs(values.tanggalRetur).format('DDMMYYYY'),
        tanggalDiRetur: dayjs(dlkData.tanggaldokumen).format('DDMMYYYY'),

        masaPajak: values.masaPajak,
        tahunPajak: values.tahunPajak,

        jumlahDpp: num(values.jumlahDpp),
        jumlahPpn: num(values.jumlahPpn),
        jumlahPpnbm: num(values.jumlahPpnbm),
      };

      // 🔒 VALIDASI MAX RETUR
      //   if (payload.jumlahDpp > num(dlkData.returMaxDpp)) {
      //     throw new Error(`Jumlah DPP melebihi maksimum (${dlkData.returMaxDpp})`);
      //   }

      //   if (payload.jumlahPpn > num(dlkData.returMaxPpn)) {
      //     throw new Error(`Jumlah PPN melebihi maksimum (${dlkData.returMaxPpn})`);
      //   }

      //   if (payload.jumlahPpnbm > num(dlkData.returMaxPpnbm)) {
      //     throw new Error(`Jumlah PPnBM melebihi maksimum (${dlkData.returMaxPpnbm})`);
      //   }

      return fakturApi.returDokumenLainKeluaran(payload);
    },

    onSuccess: () => {
      enqueueSnackbar('Retur berhasil dikirim', { variant: 'success' });
      onSuccess?.();
    },

    onError: (err: any) => {
      enqueueSnackbar(err.message || 'Gagal mengirim retur', {
        variant: 'error',
      });
    },
  });
