export type TBaseResponseAPI<T> = {
  status: string;
  message: string;
  data: T;
  time: string;
  code: number;
  metaPage: TBaseResponseMetaPage;
  total?: number;
};

type TResponseData = {};

type TBaseResponseMetaPage = {
  pageNum: number | null;
  rowPerPage: number | null;
  totalRow: number;
};

export type TGetListDataTableDn = {
  id: number;
  npwpPemotong: string;
  idTku: string;
  masaPajak: string;
  tahunPajak: string;
  fgNpwpNik: string;
  npwp: string;
  nik: string;
  nama: string;
  sertifikatInsentifDipotong: string;
  nomorSertifikatInsentif: string;
  kodeObjekPajak: string;
  pasalPPh: string;
  statusPPh: string;
  dpp: string;
  tarif: string;
  pphDipotong: string;
  kap: string;
  kjs: string;
  tglpemotongan: string;
  userId: string;
  created_at: string;
  updated_at: string;
  created_by: string;
  updated_by: string;
  fgStatus: string;
  internal_id: string;
  dokumen_referensi: {
    dokReferensi: string;
    nomorDokumen: string;
    tanggal_Dokumen: string;
    metodePembayaranBendahara: string;
    nomorSP2D: string;
  }[];
  revNo: number;
  noBupot: string | null;
  idBupot: string | null;
  npwpNikPenandatangan: string;
  namaPenandatangan: string;
  link: string | null;
  errorMsg: string | null;
  email: string | null;
  glAccount: string;
  fgkirimemail: string;
  glName: string | null;
  keterangan1: string | null;
  keterangan2: string | null;
  keterangan3: string | null;
  keterangan4: string | null;
  keterangan5: string | null;
  fgLapor: string;
};

export type TGetListDataTableDnResult = TGetListDataTableDn[];

export type TGetListDataKOPDn = {
  dtp: number;
  kap: string;
  kjs: string;
  kode: string;
  nama: string;
  noCertificate: number;
  normanetto: string;
  otherCert: number;
  pasal: string;
  skbBungaTabungan: number;
  skbPHTB: number;
  skbPasal22: number;
  skbPasal23: number;
  statuspph: string;
  suket: number;
  tarif: string;
};

export type TGetListDataKOPDnResult = TGetListDataKOPDn[];

export type ActionItem = {
  title: string;
  icon: React.ReactNode;
  func?: () => void;
  disabled?: boolean;
};

export type TPostDnRequest = {
  id: string | null;
  idBupot: string;
  noBupot: string;
  npwpPemotong: string;
  idTku: string;
  masaPajak: string;
  tahunPajak: number;
  npwp: string;
  nik: string;
  nama: string;
  revNo: number;
  fgNpwpNik: string; // static "true"
  fgJnsBupot: string; // static "BPU"
  dataDetilBpu: {
    sertifikatInsentifDipotong: string;
    nomorSertifikatInsentif: string;
    kodeObjekPajak: string;
    pasalPPh: string;
    statusPPh: string;
    dpp: string;
    tarif: string;
    pphDipotong: string;
    kap: string;
    kjs: string;
    dokReferensi: {
      dokReferensi: string;
      nomorDokumen: string;
      tanggal_Dokumen: string;
      metodePembayaranBendahara: string;
      nomorSP2D: string;
    }[];
  };
  tglPemotongan: string;
  email: string;
  glAccount: string;
  keterangan1: string;
  keterangan2: string;
  keterangan3: string;
  keterangan4: string;
  keterangan5: string;
};

export type TPostUpload = {
  id: string;
};

export type TDeleteDnRequest = {
  id: string;
};

export type TCancelDnRequest = {
  id: string | number;
  tglPembatalan: string; // format: DDMMYYYY
};

export type TCancelDnResponse = TBaseResponseAPI<{
  id: string | number;
  statusBatal?: string;
  message?: string;
}>;
