import { fetcher } from 'src/lib/axios';
import type {
  BupotRecord,
  TBaseResponseAPI,
  TGetListDataKOPDnResult,
  TGetListDataTableDnResult,
  TPortBulananUploadRequest,
  TPostBulananRequest,
} from '../types/types';

const bulananApi = () => {};

// API untuk get list table
bulananApi.getList = async (config: any) => {
  const response = await fetcher<TBaseResponseAPI<TGetListDataTableDnResult>>([
    'IF_TXR_028/a0',
    {
      method: 'GET',
      ...config,
    },
  ]);

  if (!response || response.status !== 'success') {
    throw new Error(response?.message || 'Failed to fetch bulanan data');
  }

  const { metaPage, data } = response;
  return { total: metaPage ? Number(metaPage.totalRow) : 0, data };
};

// ✅ adjust biar bisa terima params
bulananApi.getKodeObjekPajak = async (params?: Record<string, any>) => {
  const response = await fetcher<TBaseResponseAPI<TGetListDataKOPDnResult>>([
    '/sandbox/mst_kop_bpu',
    {
      method: 'GET',
      params, // ⬅️ inject ke query string
    },
  ]);

  if (!response || response.status !== 'success') {
    throw new Error(response?.message || 'Failed to fetch kode objek pajak');
  }

  return response;
};

bulananApi.save = async (config: TPostBulananRequest) => {
  const response = await fetcher<TBaseResponseAPI<BupotRecord>>([
    '/IF_TXR_028/a0',
    {
      method: 'POST',
      data: config,
    },
  ]);

  if (!response || response.status !== 'success') {
    throw new Error(response?.message || 'Failed to save bulanan data');
  }

  return response.data;
};

bulananApi.upload = async (config: TPortBulananUploadRequest) => {
  const response = await fetcher<TBaseResponseAPI<BupotRecord>>([
    '/IF_TXR_028/a0/upload',
    {
      method: 'POST',
      data: config,
    },
  ]);

  if (!response || response.status !== 'success') {
    throw new Error(response?.message || 'Failed to upload bulanan data');
  }

  return response.data;
};

export default bulananApi;
