import React, { useEffect, useState } from 'react';
import DialogUmum from 'src/shared/components/dialog/DialogUmum';
import DialogContent from '@mui/material/DialogContent';
import ListDetailBuilder from '../ListDetailItem';
import StatusChip from '../StatusChip';
import dayjs from 'dayjs';
import utc from 'dayjs/plugin/utc';
import timezone from 'dayjs/plugin/timezone';

dayjs.extend(utc);
dayjs.extend(timezone);

interface ModalCetakPdfSspProps {
  payload?: Record<string, any>;
  isOpen: boolean;
  onClose: () => void;
}

type Row = { label: string; value: React.ReactNode };

const ModalCetakPdfSsp: React.FC<ModalCetakPdfSspProps> = ({ payload, isOpen, onClose }) => {
  const [rows, setRows] = useState<Row[]>([]);

  useEffect(() => {
    if (!payload) return;

    console.log(payload);

    const periode =
      payload.msPajak && payload.thnPajak ? `${payload.msPajak} - ${payload.thnPajak}` : '-';

    const formattedRows: Row[] = [
      { label: 'Periode', value: periode },
      { label: 'Kode Objek Pajak', value: payload.kdObjPjk || '-' },
      { label: 'Nomor Bukti Pemotongan', value: payload.noBupot || '-' },
      {
        label: 'Identitas Dipotong',
        value: payload.nitkuPemotong,
      },
      { label: 'Nama Dipotong', value: payload.namaPenandatangan || '-' },
      {
        label: 'Jumlah Bruto (Rp)',
        value: payload.jmlBruto,
      },
      {
        label: 'Tarif (%)',
        value: `${Number(payload.tarif || 0)}`,
      },
      {
        label: 'Jumlah Dipotong (Rp)',
        value: payload.pphDipotong,
      },
      {
        label: 'Perekam',
        value: payload.userId || '-',
      },
      {
        label: 'Created Date',
        value: payload.created_at
          ? dayjs(payload.created_at).local().format('DD/MM/YYYY HH:mm:ss')
          : '-',
      },
      {
        label: 'Modified By',
        value: payload.updated || '-',
      },
      {
        label: 'Modified Date',
        value: payload.updated_at
          ? dayjs(payload.updated_at).local().format('DD/MM/YYYY HH:mm:ss')
          : '-',
      },
      {
        label: 'Status',
        value: <StatusChip value={payload.fgStatus} revNo={payload.revNo} />,
      },
    ];

    setRows(formattedRows);
  }, [payload]);

  return (
    <DialogUmum
      maxWidth="lg"
      isOpen={isOpen}
      onClose={onClose}
      title="Detail Bupot Disetor Sendiri"
    >
      <DialogContent classes={{ root: 'p-16 sm:p-24' }}>
        <ListDetailBuilder rows={rows} />
      </DialogContent>
    </DialogUmum>
  );
};

export default ModalCetakPdfSsp;
