import React from 'react';
import {
  Dialog,
  DialogTitle,
  DialogContent,
  DialogActions,
  Button,
  Typography,
} from '@mui/material';

interface CancelConfirmationDialogProps {
  open: boolean;
  onClose: () => void;
  onConfirm: () => void;
  selectedCount: number;
}

const CancelConfirmationDialog: React.FC<CancelConfirmationDialogProps> = ({
  open,
  onClose,
  onConfirm,
  selectedCount,
}) => (
  <Dialog open={open} onClose={onClose}>
    <DialogTitle>Konfirmasi Pembatalan</DialogTitle>
    <DialogContent>
      <Typography>
        Apakah Anda yakin ingin membatalkan {selectedCount} data yang dipilih?
      </Typography>
    </DialogContent>
    <DialogActions>
      <Button onClick={onClose}>Batal</Button>
      <Button onClick={onConfirm} color="error" variant="contained">
        Ya, Batalkan
      </Button>
    </DialogActions>
  </Dialog>
);

export default CancelConfirmationDialog;
