import { useMutation } from '@tanstack/react-query';
import type { TDeleteDnRequest, TBaseResponseAPI } from '../types/types';
import dnApi from '../utils/api';

const useDeleteDn = (props?: any) =>
  useMutation<TBaseResponseAPI<null>, Error, TDeleteDnRequest>({
    mutationKey: ['delete-dn'],
    mutationFn: (payload) => dnApi.deleteDn(payload),
    ...props,
  });

export default useDeleteDn;
