import { useMutation } from '@tanstack/react-query';
import type { TCancelReturPMRequest, TCancelResponse } from '../types/types';
import fakturApi from '../utils/api';

const useCancelReturPM = (props?: any) =>
  useMutation<TCancelResponse, Error, TCancelReturPMRequest>({
    mutationKey: ['cancel-retur-pm'],
    mutationFn: (payload) => fakturApi.cancelReturPM(payload),
    ...props,
  });

export default useCancelReturPM;
