// hooks/useUpload.ts
import { useMutation } from '@tanstack/react-query';
import sspApi from '../utils/api';

const useUpload = (props?: any) =>
  useMutation({
    mutationKey: ['upload-ssp'],
    mutationFn: (payload: { id: string | number }) => sspApi.upload(payload),
    ...props,
  });

export default useUpload;
