// import {
//   FG_KIRIM_EMAIL as EFAKTUR_FG_KIRIM_EMAIL,
//   FG_KIRIM_EMAIL_TEXT as EFAKTUR_FG_KIRIM_EMAIL_TEXT,
// } from '@pjap/efaktur/constants/efakturConstant';

export const FG_FASILITAS = {
  YES: '1',
  NO: '0',
  BUPOT26: '2',
};

export const FG_PERHITUNGAN = {
  GROSS: '0',
  GROSS_UP: '1',
  MIXED: '2',
};

export const FG_PERHITUNGAN_TEXT = {
  [FG_PERHITUNGAN.GROSS]: 'Gross',
  [FG_PERHITUNGAN.GROSS_UP]: 'Gross Up',
  [FG_PERHITUNGAN.MIXED]: 'Mixed',
};

export const PPH_21_AKTIF = {
  YES: 1,
  NO: 0,
};

// export const FG_KIRIM_EMAIL = EFAKTUR_FG_KIRIM_EMAIL;
// export const FG_KIRIM_EMAIL_TEXT = EFAKTUR_FG_KIRIM_EMAIL_TEXT;

export const IDENTITAS = {
  NPWP: '0',
  NIK: '1',
  PASPOR: '2',
  NPWP16: '3',
  NITKU: '4',
};

export const FG_ID_DIPOTONG = {
  NPWP: '0',
  NIK: '1',
  NPWP26: '2',
  NPWP16: '3',
  NITKU: '4',
};

export const TUJUAN = {
  PEMUTAKHIRAN: '0',
  LIST: '1',
};

export const TYPE_REFERENSI_PEGAWAI = {
  PENERIMA: 0,
  PEGAWAI: 1,
};

export const IDENTITAS_TEXT = {
  [IDENTITAS.NPWP]: 'NPWP',
  [IDENTITAS.NIK]: 'NIK',
  [IDENTITAS.PASPOR]: 'Paspor',
  [IDENTITAS.NITKU]: 'NITKU',
  [IDENTITAS.NPWP16]: 'NPWP16',
};
export const TUJUAN_TEXT = {
  [TUJUAN.PEMUTAKHIRAN]: 'Validasi NITKU',
  [TUJUAN.LIST]: 'List NITKU',
};

export const KODE_OBJEK_PAJAK = {
  BULANAN_01: '21-100-01',
  BULANAN_02: '21-100-02',
  BULANAN_03: '21-100-32',
  TIDAK_FINAL_03: '21-100-03',
  TIDAK_FINAL_04: '21-100-04',
  TIDAK_FINAL_05: '21-100-05',
  TIDAK_FINAL_06: '21-100-06',
  TIDAK_FINAL_07: '21-100-07',
  TIDAK_FINAL_09: '21-100-09',
  TIDAK_FINAL_10: '21-100-10',
  TIDAK_FINAL_11: '21-100-11',
  TIDAK_FINAL_12: '21-100-12',
  TIDAK_FINAL_13: '21-100-13',
  TIDAK_FINAL_99: '21-100-99',
  FINAL_01: '21-401-01',
  FINAL_02: '21-401-02',
  FINAL_99: '21-499-99',
  FINAL_38: '21-100-38',
  BUPOT_26: '27-100-99',
};

export const KODE_OBJEK_PAJAK_TEXT = {
  [KODE_OBJEK_PAJAK.BULANAN_01]: 'Pegawai Tetap',
  [KODE_OBJEK_PAJAK.BULANAN_02]: 'Penerima Pensiun Berkala',
  [KODE_OBJEK_PAJAK.BULANAN_03]:
    'Penghasilan yang diterima atau Diperoleh oleh Pegawai tetap yang menerima fasilitas di daerah tertentu',
  [KODE_OBJEK_PAJAK.TIDAK_FINAL_03]: 'Pegawai Tidak Tetap',
  [KODE_OBJEK_PAJAK.TIDAK_FINAL_04]: 'Distributor Pemasaran Berjenjang',
  [KODE_OBJEK_PAJAK.TIDAK_FINAL_05]: 'Agen Asuransi',
  [KODE_OBJEK_PAJAK.TIDAK_FINAL_06]: 'Penjaja Barang Dagangan',
  [KODE_OBJEK_PAJAK.TIDAK_FINAL_07]: 'Tenaga Ahli',
  [KODE_OBJEK_PAJAK.TIDAK_FINAL_09]: 'Bukan Pegawai Lainnya',
  [KODE_OBJEK_PAJAK.TIDAK_FINAL_10]:
    'Anggota Dewan Komisaris atau Dewan Pengawas yang Menerima Imbalan Secara Tidak Teratur',
  [KODE_OBJEK_PAJAK.TIDAK_FINAL_11]:
    'Mantan Pegawai yang Menerima Jasa Produksi, Tantiem, Bonus atau Imbalan Kepada Mantan Pegawai',
  [KODE_OBJEK_PAJAK.TIDAK_FINAL_12]: 'Pegawai yang Melakukan Penarikan Uang Pensiun',
  [KODE_OBJEK_PAJAK.TIDAK_FINAL_13]: 'Peserta Kegiatan',
  [KODE_OBJEK_PAJAK.TIDAK_FINAL_99]:
    'Penerima Penghasilan yang Dipotong PPh Pasal 21 Tidak Final Lainnya',
  [KODE_OBJEK_PAJAK.FINAL_01]: 'Uang Pesangon yang Dibayarkan Sekaligus',
  [KODE_OBJEK_PAJAK.FINAL_02]:
    'Penerima Uang Manfaat Pensiun, Tunjangan Hari Tua, atau Jaminan Hari Tua yang Dibayarkan Sekaligus',
  [KODE_OBJEK_PAJAK.FINAL_99]: 'Penerima Penghasilan yang Dipotong PPh Pasal 21 Final Lainnya',
  [KODE_OBJEK_PAJAK.BUPOT_26]:
    'Pegawai/Pemberi Jasa/Peserta Kegiatan/Penerima Pensiun Berkala Sebagai Wajib Pajak Luar Negeri',
};

export const PTKP = {
  TK_0: 'TK/0',
  TK_1: 'TK/1',
  TK_2: 'TK/2',
  TK_3: 'TK/3',
  K_0: 'K/0',
  K_1: 'K/1',
  K_2: 'K/2',
  K_3: 'K/3',
  HB_0: 'HB/0',
  HB_1: 'HB/1',
  HB_2: 'HB/2',
  HB_3: 'HB/3',
};

export const PTKP_TEXT = {
  [PTKP.TK_0]: `(${PTKP.TK_0}) - 54.000.000`,
  [PTKP.TK_1]: `(${PTKP.TK_1}) - 58.500.000`,
  [PTKP.TK_2]: `(${PTKP.TK_2}) - 63.000.000`,
  [PTKP.TK_3]: `(${PTKP.TK_3}) - 67.500.000`,
  [PTKP.K_0]: `(${PTKP.K_0}) - 58.500.000`,
  [PTKP.K_1]: `(${PTKP.K_1}) - 63.000.000`,
  [PTKP.K_2]: `(${PTKP.K_2}) - 67.500.000`,
  [PTKP.K_3]: `(${PTKP.K_3}) - 72.000.000`,
  [PTKP.HB_0]: `(${PTKP.HB_0}) - 54.000.000`,
  [PTKP.HB_1]: `(${PTKP.HB_1}) - 58.500.000`,
  [PTKP.HB_2]: `(${PTKP.HB_2}) - 63.000.000`,
  [PTKP.HB_3]: `(${PTKP.HB_3}) - 67.500.000`,
};

export const PTKP_INPUT = {
  [PTKP.TK_0]: '54000000',
  [PTKP.TK_1]: '58500000',
  [PTKP.TK_2]: '63000000',
  [PTKP.TK_3]: '67500000',
  [PTKP.K_0]: '58500000',
  [PTKP.K_1]: '63000000',
  [PTKP.K_2]: '67500000',
  [PTKP.K_3]: '72000000',
};

export const MIN_THN_PAJAK = 2022;

export const PTKP_TITLE = {
  TK: 'TK',
  K: 'K',
  HB: 'HB',
};

export const JENIS_PERHITUNGAN = {
  HARIAN: '0',
  BULANAN: '1',
};

export const JENIS_PERHITUNGAN_TEXT = {
  [JENIS_PERHITUNGAN.BULANAN]: `${KODE_OBJEK_PAJAK.TIDAK_FINAL_03} : Upah (Pegawai Tidak Tetap Bulanan)`,
  [JENIS_PERHITUNGAN.HARIAN]: `${KODE_OBJEK_PAJAK.TIDAK_FINAL_03} : Upah (Pegawai Tidak Tetap Non Bulanan)`,
};

export const PERHITUNGAN_BUPOT21 = {
  BULANAN_GROSS: 'bulanan',
  BULANAN_GROSS_UP: 'bulanan-gross-up',
  BULANAN_MIXED: 'bulanan-mixed',
  HARIAN: 'harian',
  PASAL17: 'pasal17',
  FINAL: 'final',
  TIDAK_FINAL: 'final',
  BULANAN: 'TARIF TER BULANAN',
  PENSIUN: 'TARIF PENSIUN',
  HARIAN_TER: 'TARIF TER HARIAN',
  PASAL_17: 'TARIF PASAL 17',
  PESANGON: 'TARIF PESANGON',
};

export const SAVE_BUPOT21 = {
  BULANAN: 'bulanan',
  FINAL_NON_FINAL: 'final-non-final',
};

export const FG_BUPOT = {
  HARIAN: '0',
  BULANAN: '1',
};

// export const FG_STATUS = {
//   NORMAL: '0',
//   NORMAL_PENGGANTI: '1',
//   DIGANTI: '2',
//   BATAL: '3',
//   HAPUS: '4',
//   SUBMITTED: '5',
//   DRAFT: '6',
//   FAILED: '7',
//   PENDING: '8',
//   EXTERNAL: '9',
//   ON_SCHEDULE: '10',
// };

export const FG_STATUS: Record<string, string> = {
  '0': 'NORMAL',
  '1': 'NORMAL_PENGGANTI',
  '2': 'DIGANTI',
  '3': 'BATAL',
  '4': 'HAPUS',
  '5': 'SUBMITTED',
  '6': 'DRAFT',
  '7': 'FAILED',
  '8': 'PENDING',
  '9': 'EXTERNAL',
  '10': 'ON_SCHEDULE',
};

export const FG_PDF_STATUS = {
  TERBENTUK: '0',
  BELUM_TERBENTUK: '1',
  TIDAK_TERSEDIA: '2',
};

export const FG_PDF_STATUS_TEXT = {
  [FG_PDF_STATUS.TERBENTUK]: 'Terbentuk',
  [FG_PDF_STATUS.BELUM_TERBENTUK]: 'Belum Terbentuk',
  [FG_PDF_STATUS.TIDAK_TERSEDIA]: 'Tidak Tersedia',
};
export const FG_SIGN_STATUS = {
  IN_PROGRESS: '1',
  FAILED: '2',
  SIGNED: '0',
  ERROR: '3',
  DUPLICATE: '4',
  NOT_MATCH_IDBUPOT: '5',
  NOT_MATCH_STATUS: '6',
  NOT_MATCH_NILAI: '7',
};

export const FG_SIGN_STATUS_TEXT = {
  [FG_SIGN_STATUS.IN_PROGRESS]: 'In Progress',
  [FG_SIGN_STATUS.FAILED]: 'Failed',
  [FG_SIGN_STATUS.ERROR]: 'Error',
  [FG_SIGN_STATUS.DUPLICATE]: 'Duplicate',
  [FG_SIGN_STATUS.NOT_MATCH_IDBUPOT]: 'Not Match Id Bupot',
  [FG_SIGN_STATUS.NOT_MATCH_STATUS]: 'Not Match Status',
  [FG_SIGN_STATUS.NOT_MATCH_NILAI]: 'Not Match Nilai',
  [FG_SIGN_STATUS.SIGNED]: 'Approved',
};

export const FG_SIGN_STATUS_COLOR = {
  [FG_SIGN_STATUS.IN_PROGRESS]: 'primary',
  [FG_SIGN_STATUS.FAILED]: 'error',
  [FG_SIGN_STATUS.ERROR]: 'error',
  [FG_SIGN_STATUS.DUPLICATE]: 'error',
  [FG_SIGN_STATUS.NOT_MATCH_IDBUPOT]: 'error',
  [FG_SIGN_STATUS.NOT_MATCH_STATUS]: 'error',
  [FG_SIGN_STATUS.NOT_MATCH_NILAI]: 'error',
  [FG_SIGN_STATUS.SIGNED]: 'success',
};

export const PENGURUS_KUASA = {
  PENGURUS: '0',
  KUASA: '1',
};

export const FG_STATUS_TEXT = {
  [FG_STATUS.NORMAL]: 'Normal',
  [FG_STATUS.NORMAL_PENGGANTI]: 'Normal Pengganti',
  [FG_STATUS.SUBMITTED]: 'Submitted',
  [FG_STATUS.DRAFT]: 'Draft',
  [FG_STATUS.DIGANTI]: 'Diganti',
  [FG_STATUS.BATAL]: 'Dibatalkan',
  [FG_STATUS.HAPUS]: 'Dihapus',
  [FG_STATUS.PENDING]: 'Pending',
  [FG_STATUS.FAILED]: 'Failed',
  [FG_STATUS.EXTERNAL]: 'External',
  [FG_STATUS.ON_SCHEDULE]: 'On Schedule',
};

export const FG_STATUS_COLOR = {
  [FG_STATUS.NORMAL]: 'primary',
  [FG_STATUS.NORMAL_PENGGANTI]: 'primary',
  [FG_STATUS.SUBMITTED]: 'primary',
  [FG_STATUS.DRAFT]: 'default',
  [FG_STATUS.DIGANTI]: 'secondary',
  [FG_STATUS.FAILED]: 'error',
  [FG_STATUS.BATAL]: 'error',
  [FG_STATUS.HAPUS]: 'error',
  [FG_STATUS.PENDING]: 'error',
  [FG_STATUS.EXTERNAL]: 'default',
  [FG_STATUS.ON_SCHEDULE]: 'warning',
};

export const FG_POSTING = {
  BELUM_POSTING: '0',
  SUDAH_POSTING: '1',
};

export const FG_POSTING_TEXT = {
  [FG_POSTING.BELUM_POSTING]: 'Belum Posting',
  [FG_POSTING.SUDAH_POSTING]: 'Sudah Posting',
};

export const FG_POSTING_COLOR = {
  [FG_POSTING.BELUM_POSTING]: 'default',
  [FG_POSTING.SUDAH_POSTING]: 'success',
};

export const FG_LAPOR = {
  BELUM_LAPOR: '0',
  SUDAH_LAPOR: '1',
};

export const FG_LAPOR_TEXT = {
  [FG_LAPOR.BELUM_LAPOR]: 'Belum Lapor',
  [FG_LAPOR.SUDAH_LAPOR]: 'Sudah Lapor',
};

export const FG_LAPOR_COLOR = {
  [FG_LAPOR.BELUM_LAPOR]: 'error',
  [FG_LAPOR.SUDAH_LAPOR]: 'success',
};

export const KD_BUPOT = {
  LAINNYA: '0',
  BULANAN: '1',
};

export const JNS_TRX = {
  CREATE_AND_EDIT: 'NEW',
  PEMBETULAN: 'EDIT',
};

export const FEATURE = {
  BULANAN: '1',
  TIDAK_FINAL: '2',
  FINAL: '3',
  A1_1721: '4',
  BUPOT_26: '5',
  A2_1721: '6',
  REKON_BULANAN: '7',
  REKON_TIDAK_FINAL: '8',
  REKON_FINAL: '9',
  REKON_A1_1721: '10',
  REKON_BUPOT_26: '11',
  MASTER_PEGAWAI_A1: '12',
  MASTER_PENERIMA_PENGHASILAN: '13',
};

export const FEATURE_UPDATE_VSWP = {
  BULANAN: 'a0',
  FINAL_TIDAK_FINAL: '21',
  A1_1721: 'a1',
  UNIFIKASI: 'bpu',
  PREPOP_UNIFIKASI: 'bpup',
  MASTER_PEGAWAI_A1: 'masterPegawai',
  MASTER_PENERIMA_PENGHASILAN: 'masterNonPegawai',
};

export const REV_NO_DEFAULT = '0';

export const FG_AKUMULASI_JUMLAH_BRUTO = {
  YES: '1',
  NO: '0',
};

export const DAFTAR_JNS_PEGAWAI = {
  PENERIMA_PENGHASILAN: '0',
  PEGAWAI_TETAP: '1',
};

export const DAFTAR_JNS_PEGAWAI_TEXT = {
  [DAFTAR_JNS_PEGAWAI.PENERIMA_PENGHASILAN]: 'Daftar Selain Pegawai Tetap',
  [DAFTAR_JNS_PEGAWAI.PEGAWAI_TETAP]: 'Daftar Pegawai Tetap',
};

export const FG_JENIS_BUKTI_POTONG_NON_PLUS = {
  BULANAN_TIDAK_FINAL: '0',
  TIDAK_FINAL_FINAL: '1',
  TAHUNAN: '2',
  BUPOT_26: '3',
};

export const FG_JENIS_BUKTI_POTONG = {
  BULANAN: '0',
  TIDAK_FINAL_FINAL: '1',
  TAHUNAN: '2',
  BUPOT_26: '3',
  REKON_BULANAN: '4',
  REKON_FINAL_TDK_FINAL: '5',
};

export const FG_JENIS_BUKTI_POTONG_TEXT = {
  [FG_JENIS_BUKTI_POTONG.BULANAN]: 'Bulanan',
  [FG_JENIS_BUKTI_POTONG.TIDAK_FINAL_FINAL]: 'Final/Tidak Final',
  [FG_JENIS_BUKTI_POTONG.TAHUNAN]: 'Tahunan',
  [FG_JENIS_BUKTI_POTONG.BUPOT_26]: 'Bupot 26',
  [FG_JENIS_BUKTI_POTONG.REKON_BULANAN]: 'Rekon Bupot Bulanan (Genta)',
  [FG_JENIS_BUKTI_POTONG.REKON_FINAL_TDK_FINAL]: 'Rekon Bupot Final/Tidak Final (Genta)',
};

export const FG_JENIS_BUKTI_POTONG_NON_PLUS_TEXT = {
  [FG_JENIS_BUKTI_POTONG_NON_PLUS.BULANAN_TIDAK_FINAL]: 'Bulanan',
  [FG_JENIS_BUKTI_POTONG_NON_PLUS.TIDAK_FINAL_FINAL]: 'Final/Tidak Final',
  [FG_JENIS_BUKTI_POTONG_NON_PLUS.TAHUNAN]: 'Tahunan',
  [FG_JENIS_BUKTI_POTONG_NON_PLUS.BUPOT_26]: 'Bupot 26',
};

export const FG_JENIS_BUKTI_POTONG_PLUS = {
  BULANAN: '0',
  TIDAK_FINAL_FINAL: '1',
  BUPOT_26: '3',
};

export const FG_JENIS_BUKTI_POTONG_PLUS_TEXT = {
  [FG_JENIS_BUKTI_POTONG_PLUS.BULANAN]: 'Bulanan',
  [FG_JENIS_BUKTI_POTONG_PLUS.TIDAK_FINAL_FINAL]: 'Tidak Final/Final',
  [FG_JENIS_BUKTI_POTONG_PLUS.BUPOT_26]: 'Bupot 26',
};

export const FG_TAHUNAN = {
  YES: '1',
  NO: '0',
};

export const FG_TAHUNAN_TEXT = {
  [FG_TAHUNAN.YES]: 'Ya',
  [FG_TAHUNAN.NO]: 'Tidak',
};

export const FG_DATA_IMPORT = {
  BARU: '0',
  UPDATE: '1',
};

export const FG_DATA_IMPORT_TEXT = {
  [FG_DATA_IMPORT.BARU]: 'Data Baru',
  [FG_DATA_IMPORT.UPDATE]: 'Data Detail Eksternal',
};

export const FG_TRANSACTION = {
  CREATE_OR_EDIT: 'NEW',
  PENGGANTI: 'EDIT',
  CANCEL: 'CANCELED',
};

export const JENIS_REFERENSI = {
  PENERIMA_PENGHASILAN: '0',
  PEGAWAI_TETAP: '1',
};

export const FG_FASILITAS_PPH_21 = {
  DTP: '4',
  FASILITAS_LAINNYA: '8',
  TANPA_FASILITAS: '9',
  SKB_PPH_PASAL_21: '10',
  DTP_PPH_PASAL_21: '11',
};

export const FG_FASILITAS_PPH_21_TEXT = {
  [FG_FASILITAS_PPH_21.DTP]: 'DTP',
  [FG_FASILITAS_PPH_21.TANPA_FASILITAS]: 'Tanpa Fasilitas',
  [FG_FASILITAS_PPH_21.FASILITAS_LAINNYA]: 'Fasilitas Lainnya',
  [FG_FASILITAS_PPH_21.SKB_PPH_PASAL_21]: 'SKB PPh Pasal 21',
};

export const STATUS_PPH = {
  FINAL: 'Final',
  TIDAK_FINAL: 'Tidak Final',
};

export const PASAL_PPH = {
  PASAL_21: 'Pasal 21',
};

export const BUPOT_REFERENSI = {
  PENGUMUMAN: 'ANNOUNCEMENT',
  INVOICE: 'COMMERCIALINVOICE',
  KONTRAK: 'CONTRACT',
  NOMOR_AKUN: 'CURRENTACCOUNT',
  AKTA_PERJANJIAN: 'DEEDOFENGAGEMENT',
  AKTA_RUPS: 'DEEDOFGENERAL',
  LAINNYA: 'OTHER',
  BUKTI_BAYAR: 'PAYMENTPROOF',
  SURAT_PERNYATAAN: 'STATEMENTLETTER',
  FAKTUR_PAJAK: 'TAXINVOICE',
  KONFIRMASI_TRANSAKSI: 'TRADECONFIRMATION',
};

export const BUPOT_REFERENSI_TEXT = {
  [BUPOT_REFERENSI.PENGUMUMAN]: 'Pengumuman',
  [BUPOT_REFERENSI.INVOICE]: 'Faktur pembelian',
  [BUPOT_REFERENSI.KONTRAK]: 'Kontrak',
  [BUPOT_REFERENSI.NOMOR_AKUN]: 'Nomor account',
  [BUPOT_REFERENSI.AKTA_PERJANJIAN]: 'Akta perjanjian',
  [BUPOT_REFERENSI.AKTA_RUPS]: 'Akta RUPS',
  [BUPOT_REFERENSI.LAINNYA]: 'Lainnya',
  [BUPOT_REFERENSI.BUKTI_BAYAR]: 'Bukti bayar',
  [BUPOT_REFERENSI.SURAT_PERNYATAAN]: 'Surat pernyataan',
  [BUPOT_REFERENSI.FAKTUR_PAJAK]: 'Faktur Pajak',
  [BUPOT_REFERENSI.KONFIRMASI_TRANSAKSI]: 'Konfirmasi transaksi',
};

export const PANGKAT_GOLONGAN = {
  GOLONGAN_I: 'Golongan I',
  GOLONGAN_II: 'Golongan II',
  GOLONGAN_III: 'Golongan III',
  GOLONGAN_IV: 'Golongan IV',
};

export const JENIS_REKAP = {
  DETAIL: 'detail',
  SUMMARY: 'summary',
};

// Start Dari Sini
export const FG_FASILITAS_DN = {
  SKB_PPH_PASAL_22: '1',
  SKB_PPH_PASAL_23: '2',
  SKB_PPH_PHTB: '3',
  DTP: '4',
  SKB_PPH_BUNGA_DEPOSITO_DANA_PENSIUN_TABUNGAN: '5',
  SUKET_PP23_PP52: '6',
  SKD_WPLN: '7',
  FASILITAS_LAINNYA: '8',
  TANPA_FASILITAS: '9',
  SKB_PPH_PASAL_21: '10',
  DTP_PPH_PASAL_21: '11',
};

export const FG_FASILITAS_OPTIONS = {
  SKB_PPH_PASAL_22: '1',
  SKB_PPH_PASAL_23: '2',
  SKB_PPH_PHTB: '3',
  DTP: '4',
  SKB_PPH_BUNGA_DEPOSITO_DANA_PENSIUN_TABUNGAN: '5',
  SUKET_PP23_PP52: '6',
  SKD_WPLN: '7',
  FASILITAS_LAINNYA: '8',
  TANPA_FASILITAS: '9',
  SKB_PPH_PASAL_21: '10',
  DTP_PPH_PASAL_21: '11',
};

export const FG_FASILITAS_MASTER_KEY = {
  [FG_FASILITAS_DN.SKB_PPH_PASAL_21]: 'skb21',
  [FG_FASILITAS_DN.SKB_PPH_PASAL_22]: 'skbPasal22',
  [FG_FASILITAS_DN.SKB_PPH_PASAL_23]: 'skbPasal23',
  [FG_FASILITAS_DN.SKB_PPH_PHTB]: 'skbPHTB',
  [FG_FASILITAS_DN.SKD_WPLN]: 'certofDomicile',
  [FG_FASILITAS_DN.DTP]: 'dtp',
  [FG_FASILITAS_DN.SKB_PPH_BUNGA_DEPOSITO_DANA_PENSIUN_TABUNGAN]: 'skbBungaTabungan',
  [FG_FASILITAS_DN.SUKET_PP23_PP52]: 'suket',
  [FG_FASILITAS_DN.FASILITAS_LAINNYA]: 'otherCert',
  [FG_FASILITAS_DN.TANPA_FASILITAS]: 'noCertificate',
};

export const FG_FASILITAS_TEXT = {
  [FG_FASILITAS_DN.SKB_PPH_PASAL_22]: 'SKB PPh Pasal 22',
  [FG_FASILITAS_DN.SKB_PPH_PASAL_23]: 'SKB PPh Pasal 23',
  [FG_FASILITAS_DN.SKB_PPH_PHTB]: 'SKB PPh PHTB',
  [FG_FASILITAS_DN.DTP]: 'DTP',
  [FG_FASILITAS_DN.SKB_PPH_BUNGA_DEPOSITO_DANA_PENSIUN_TABUNGAN]:
    'SKB PPh atas bunga deposito, dana pensiun, tabungan',
  [FG_FASILITAS_DN.SKD_WPLN]: 'SKD WPLN',
  [FG_FASILITAS_DN.SUKET_PP23_PP52]: 'Suket PP23/PP52',
  [FG_FASILITAS_DN.FASILITAS_LAINNYA]: 'Fasilitas Lainnya',
  [FG_FASILITAS_DN.TANPA_FASILITAS]: 'Tanpa Fasilitas',
  [FG_FASILITAS_DN.SKB_PPH_PASAL_21]: 'SKB PPh Pasal 21',
  [FG_FASILITAS_DN.DTP_PPH_PASAL_21]: 'DTP PPh Pasal 21',
};

export const TARIF_0 = [
  FG_FASILITAS_DN.SKB_PPH_PASAL_22,
  FG_FASILITAS_DN.SKB_PPH_PASAL_23,
  FG_FASILITAS_DN.SKB_PPH_PHTB,
  FG_FASILITAS_DN.SKB_PPH_BUNGA_DEPOSITO_DANA_PENSIUN_TABUNGAN,
];

export const JENIS_DOKUMEN = [
  {
    value: 'ANNOUNCEMENT',
    label: 'Pengumuman',
  },
  {
    value: 'COMMERCIALINVOICE',
    label: 'Faktur  pembelian',
  },
  {
    value: 'CONTRACT',
    label: 'Kontrak',
  },
  {
    value: 'CURRENTACCOUNT',
    label: 'Nomor  account',
  },
  {
    value: 'DEEDOFENGAGEMENT',
    label: 'Akta  perjanjian',
  },
  {
    value: 'DEEDOFGENERAL',
    label: 'Akta RUPS',
  },
  {
    value: 'PAYMENTPROOF',
    label: 'Bukti bayar',
  },
  {
    value: 'STATEMENTLETTER',
    label: 'Surat pernyataan',
  },
  {
    value: 'TAXINVOICE',
    label: 'Faktur Pajak',
  },
  {
    value: 'TRADECONFIRMATION',
    label: 'Konfirmasi transaksi',
  },
  {
    value: 'OTHER',
    label: 'Lainnya',
  },
];

export const PANDUAN_REKAM_DN = {
  description: {
    intro:
      'Form ini digunakan untuk melakukan perekaman data baru Bukti Pemotongan PPh Unifikasi serta perubahannya.\n',
    textList: 'Form ini terdiri dari beberapa bagian antara lain:',
    list: [
      'Bagian I, Identitas Wajib Pajak yang Dipotong/Dipungut',
      'Bagian II, Pajak Penghasilan yang Dipotong/Dipungut',
      'Bagian III, Dokumen Dasar Pemotongan',
      'Bagian IV, Identitas Pemotong Pajak',
    ],
    closing: 'Berikut ini petunjuk pengisian pada masing-masing bagian:',
  },

  sections: [
    {
      title: 'BAGIAN I, Identitas Wajib Pajak yang Dipotong/Dipungut',
      items: [
        {
          text: 'Tahun Pajak, Tentukan tahun pajak saat melakukan pemotongan Pajak Penghasilan, tahun paling awal adalah 2022.',
          subItems: [],
        },
        {
          text: 'Masa Pajak, Tentukan Masa Pajak yang sesuai untuk transaksi pemotongan Pajak Penghasilan, pilihan terdiri dari masa Januari s.d. Desember bergantung pada tahun pajak yang Anda pilih.',
          subItems: [],
        },
        {
          text: 'Identitas, isikan sesuai dengan nomor identitas, identitas yang diperbolehkan digunakan hanya NPWP atau NIK (KTP), jika tidak memiliki, maka tidak diperbolehkan untuk dilakukan perekaman data dengan ketentuan yang berlaku.',
          subItems: [],
        },
        {
          text: 'Tidak diperbolehkan menggunakan identitas yang tidak valid.',
          subItems: [],
        },
        {
          text: 'Nama, isikan dengan nama Wajib Pajak sesuai dengan nomor identitas yang dimasukkan.',
          subItems: [],
        },
        {
          text: 'Jika terdapat transaksi perwakilan, centang kolom QQ dan isikan nama Wajib Pajak yang diwakili.',
          subItems: [],
        },
        {
          text: 'Jika menggunakan NIK, isikan kolom Alasan pengisian NIK tanpa validasi.',
          subItems: [],
        },
      ],
    },
    {
      title: 'BAGIAN II, Penghasilan yang Dipotong/Dipungut',
      items: [
        {
          text: 'Pilih Kode Objek Pajak dari pilihan yang tersedia, Anda dapat mengetikkan kata kunci untuk mempercepat pencarian objek pajak.',
          subItems: [],
        },
        {
          text: 'Pilihlah fasilitas yang dimiliki oleh Wajib Pajak:',
          subItems: [
            'Jika tidak memiliki fasilitas, maka pilihlah pilihan tanpa fasilitas pada pilihan yang tersedia. Tidak memiliki fasilitas akan menjadi pilihan utama (default).',
            'Jika memiliki fasilitas berupa Surat Keterangan Bebas (SKB), masukkan nomor SKB yang dimiliki.',
            'Jika memiliki fasilitas DTP, masukkan Nomor Dokumen Pendukung.',
            'Jika memiliki fasilitas lainnya, masukkan Nomor Dokumen Fasilitas lainnya.',
          ],
        },
        {
          text: 'Dengan memilih Kode Objek Pajak, Sistem akan melakukan pencarian secara otomatis tarif dari jenis objek pajak.',
          subItems: [],
        },
        {
          text: 'Isikan nilai nominal Penghasilan Bruto pada kotak yang tersedia, Sistem akan menghitung secara otomatis nilai Pajak Penghasilan yang Dipotong/Dipungut.',
          subItems: [],
        },
      ],
    },
    {
      title: 'BAGIAN III, Dokumen Pendukung',
      items: [
        {
          text: 'Anda diharuskan mengisi minimal 1 (satu) dokumen pendukung untuk pemotongan penghasilan. Untuk mengisi dokumen pendukung, klik tombol tambah, kemudian, isilah data dokumen pendukung yang sesuai.',
          subItems: [],
        },
      ],
    },
    {
      title: 'BAGIAN IV, Identitas Pemotong Pajak',
      items: [
        {
          text: 'Pastikan Anda telah melakukan perekaman data penandatangan pada menu Pengaturan, sebelum melakukan perekaman bukti pemotongan.',
          subItems: [],
        },
        {
          text: 'Pada bagian ini, Anda harus menentukan, pihak yang akan menandatangani dokumen bukti pemotongan ini apakah Wakil Wajib Pajak/Pengurus atau Kuasa.',
          subItems: [],
        },
        {
          text: 'Pastikan isian Anda telah lengkap dan benar, kemudian centang pernyataan yang disediakan yang menunjukkan Anda telah dengan seksama memastikan kebenaran isi dari bukti pemotongan yang dibuat, kemudian klik tombol simpan untuk menyimpan data.',
          subItems: [],
        },
      ],
    },
  ],
};

export const ActionRekam = {
  REKAM: 'rekam',
  PENGGANTI: 'pengganti',
  UBAH: 'ubah',
  RETUR: 'retur',
  PEMBETULAN: 'pembetulan',
};
