import { GridPreferencePanelsValue, useGridApiContext } from '@mui/x-data-grid-premium';
import { IconButton, Tooltip } from '@mui/material';
import ViewColumnIcon from '@mui/icons-material/ViewColumn';

export default function CustomColumnsButton() {
  const apiRef = useGridApiContext();

  const handleClick = () => {
    apiRef.current?.showPreferences('columns' as GridPreferencePanelsValue); // buka panel Columns
  };

  return (
    <Tooltip title="Kolom">
      <IconButton
        size="small"
        onClick={handleClick}
        sx={{
          color: '#123375',
          '&:hover': { backgroundColor: 'rgba(18, 51, 117, 0.08)' },
        }}
      >
        <ViewColumnIcon fontSize="small" />
      </IconButton>
    </Tooltip>
  );
}
