import type {
  TBaseResponseAPI,
  TGetListDataKOPDnResult,
  TGetListDataTableDnResult,
  TPostDnRequest,
} from '../types/types';
import bulananClient from './bulananClient';

const bulananApi = () => {};

// API untuk get list table
bulananApi.getBulanan = async (config: any) => {
  const {
    data: { message, metaPage, data },
    status: statusCode,
  } = await bulananClient.get<TBaseResponseAPI<TGetListDataTableDnResult>>('IF_TXR_028/a0', {
    ...config,
  });

  if (statusCode !== 200) {
    throw new Error(message);
  }

  return { total: metaPage ? Number(metaPage.totalRow) : 0, data };
};

// ✅ adjust biar bisa terima params
bulananApi.getKodeObjekPajakBulanan = async (params?: Record<string, any>) => {
  const response = await bulananClient.get<TBaseResponseAPI<TGetListDataKOPDnResult>>(
    '/sandbox/mst_kop_bpu',
    { params } // ⬅️ inject ke query string
  );

  const body = response.data;

  if (response.status !== 200 || body.status !== 'success') {
    throw new Error(body.message);
  }

  return body;
};

bulananApi.saveBulanan = async (config: TPostDnRequest) => {
  const {
    data: { message, data },
    status: statusCode,
  } = await bulananClient.post<TBaseResponseAPI<TPostDnRequest>>('/IF_TXR_028/a0', {
    ...config,
  });
  if (statusCode !== 200) {
    throw new Error(message);
  }

  return data;
};

export default bulananApi;
