import axios from 'axios';

const BASE_URL = `https://nodesandbox.pajakexpress.id:1837`;

const unifikasiClient = axios.create({
  baseURL: BASE_URL,
  validateStatus(status) {
    return (status >= 200 && status < 300) || status === 500;
  },
});

// Interceptor untuk selalu update token dari localStorage
unifikasiClient.interceptors.request.use((config) => {
  const jwtAccessToken = localStorage.getItem('jwt_access_token');
  const xToken = localStorage.getItem('x-token');

  if (jwtAccessToken) {
    config.headers.Authorization = `Bearer ${jwtAccessToken}`;
  }

  if (xToken) {
    config.headers['x-token'] = xToken;
  }

  return config;
});

export default unifikasiClient;
