import { useMutation } from '@tanstack/react-query';
import type { TCancelRequest, TCancelResponse } from '../types/types';
import fakturApi from '../utils/api';

const useCancelFakturPk = (props?: any) =>
  useMutation<TCancelResponse, Error, TCancelRequest>({
    mutationKey: ['cancel-faktur-pk'],
    mutationFn: (payload) => fakturApi.cancel(payload),
    ...props,
  });

export default useCancelFakturPk;
