import { useMutation, type UseMutationOptions } from '@tanstack/react-query';
import type { TBaseResponseAPI, TRequestDokumenLainMasukanPrep } from '../types/types';

import fakturApi from '../utils/api';

// Hook menerima UseMutationOptions supaya bisa inject onSuccess / onError dari pemanggil
const usePrepopulatedDokumenLainMasukan = (
  options?: UseMutationOptions<TBaseResponseAPI<any>, Error, TRequestDokumenLainMasukanPrep>
) =>
  useMutation<TBaseResponseAPI<any>, Error, TRequestDokumenLainMasukanPrep>({
    mutationKey: ['prepopulated-dokumen-lain-masukan'],
    mutationFn: (payload) => fakturApi.prepopulatedDokumenLainMasukan(payload),
    ...options,
  });

export default usePrepopulatedDokumenLainMasukan;
