import { useMutation, type UseMutationOptions } from '@tanstack/react-query';
import type { TBaseResponseAPI, TPrepopulatedPMRequest } from '../types/types';

import fakturApi from '../utils/api';

// Hook menerima UseMutationOptions supaya bisa inject onSuccess / onError dari pemanggil
const usePrepopulatedPM = (
  options?: UseMutationOptions<TBaseResponseAPI<any>, Error, TPrepopulatedPMRequest>
) =>
  useMutation<TBaseResponseAPI<any>, Error, TPrepopulatedPMRequest>({
    mutationKey: ['prepopulated-faktur-pm'],
    mutationFn: (payload) => fakturApi.prepopulatedPM(payload),
    ...options,
  });

export default usePrepopulatedPM;
