const { execSync } = require('child_process');

console.log('🔍 Deep scanning React versions...');

try {
  const output = execSync(`npm ls react --all --json`, { encoding: 'utf8' });
  const tree = JSON.parse(output);

  let foundVulnerable = false;

  function scan(node) {
    if (!node.dependencies) return;

    for (const depName in node.dependencies) {
      const dep = node.dependencies[depName];
      if (depName === 'react') {
        const version = dep.version;
        if (
          (version && version.startsWith('18.') && version < '18.3.1') ||
          (version.startsWith('19.') && version < '19.0.0')
        ) {
          console.log(`❌ VULNERABLE: react@${version} found at ${dep.path}`);
          foundVulnerable = true;
        }
      }
      scan(dep);
    }
  }

  scan(tree);

  if (!foundVulnerable) {
    console.log('✅ Tidak ada React versi rentan di seluruh node_modules');
  }
} catch (e) {
  console.error('Gagal scanning:', e.message);
}
