// src/utils/gridFormatter.ts
export type Option = { value: string; label: string };

export const mapValue = (options: Option[]) => (params?: { value?: string | null }) => {
  const v = params?.value ?? null;
  if (v === null || v === undefined || v === '') return '-';
  const item = options.find((o) => String(o.value) === String(v));
  return item ? item.label : String(v);
};
