import { useMutation, type UseMutationOptions } from '@tanstack/react-query';
import type { TBaseResponseAPI, TPrepopulatedReturPKRequest } from '../types/types';

import fakturApi from '../utils/api';

// Hook menerima UseMutationOptions supaya bisa inject onSuccess / onError dari pemanggil
const usePrepopulatedReturPK = (
  options?: UseMutationOptions<TBaseResponseAPI<any>, Error, TPrepopulatedReturPKRequest>
) =>
  useMutation<TBaseResponseAPI<any>, Error, TPrepopulatedReturPKRequest>({
    mutationKey: ['prepopulated-faktur-retur-pk'],
    mutationFn: (payload) => fakturApi.prepopulatedReturPK(payload),
    ...options,
  });

export default usePrepopulatedReturPK;
