import { useMutation, type UseMutationOptions } from '@tanstack/react-query';
import queryKey from 'src/sections/bupot-21-26/constant/queryKey';
import type { TPortBulananRequest } from '../types/types';
import bulananApi from '../utils/api';

const useUploadBulanan = (
  props?: Omit<
    UseMutationOptions<any, Error, TPortBulananRequest, unknown>,
    'mutationKey' | 'mutationFn'
  >
) =>
  useMutation<any, Error, TPortBulananRequest, unknown>({
    mutationKey: queryKey.bulanan.upload,
    mutationFn: (params: TPortBulananRequest) => bulananApi.upload(params),
    ...props,
  });

export default useUploadBulanan;
