import { useMutation } from '@tanstack/react-query';
import type { TBaseResponseAPI, TDeleteNrRequest } from '../types/types';
import bupot26 from '../utils/api';
import queryKey from '../../constant/queryKey';

const useDelete = (props?: any) =>
  useMutation<TBaseResponseAPI<null>, Error, TDeleteNrRequest>({
    mutationKey: queryKey.bupot26.delete,
    mutationFn: (payload) => bupot26.delete(payload),
    ...props,
  });

export default useDelete;
