import type {
  TBaseResponseAPI,
  TCancelRequest,
  TCancelResponse,
  TDeleteRequest,
  TGetListDataKOPDigunggungResult,
  TGetListDataTableDigunggungResult,
  TPostDigunggungRequest,
} from '../types/types';

import unifikasiClient from './unifikasiClient';

const digunggungApi = () => {};

// API untuk get list table
digunggungApi.getDigunggung = async (config: any) => {
  const {
    data: { message, metaPage, data },
    status: statusCode,
  } = await unifikasiClient.get<TBaseResponseAPI<TGetListDataTableDigunggungResult>>(
    'IF_TXR_074/',
    {
      ...config,
    }
  );

  if (statusCode !== 200) {
    throw new Error(message);
  }

  return { total: metaPage ? Number(metaPage.totalRow) : 0, data };
};

digunggungApi.getKodeObjekPajakDigunggung = async (params?: Record<string, any>) => {
  const response = await unifikasiClient.get<TBaseResponseAPI<TGetListDataKOPDigunggungResult>>(
    '/sandbox/mst_kop_bpcp',
    { params }
  );

  const body = response.data;

  if (response.status !== 200 || body.status !== 'success') {
    throw new Error(body.message);
  }

  return body;
};

digunggungApi.saveDigunggung = async (config: TPostDigunggungRequest) => {
  const {
    data: { message, data, code },
  } = await unifikasiClient.post<TBaseResponseAPI<TPostDigunggungRequest>>('/IF_TXR_074/', {
    ...config,
  });
  if (code === 0) {
    throw new Error(message);
  }

  return data;
};

digunggungApi.getDigunggungById = async (id: string) => {
  const res = await unifikasiClient.get('/IF_TXR_074/', { params: { id } });

  const {
    data: { status, message, data },
    status: statusCode,
  } = res;

  if (statusCode !== 200 || status?.toLowerCase() !== 'success') {
    console.error('getDigunggungId failed:', { statusCode, status, message });
    throw new Error(message || 'Gagal mengambil data Digunggung');
  }

  const dnData = Array.isArray(data) ? data[0] : data;

  return dnData;
};

digunggungApi.upload = async ({ id }: { id: string | number }) => {
  const {
    data: { status, message, data, code },
    status: statusCode,
  } = await unifikasiClient.post('/IF_TXR_074/upload', { id });

  return { status, message, data, code, statusCode };
};

digunggungApi.deleteDigunggung = async (
  payload: TDeleteRequest,
  config?: Record<string, any>
): Promise<any> => {
  const {
    data: { status, message, data },
    status: statusCode,
  } = await unifikasiClient.post<TBaseResponseAPI<any>>('/IF_TXR_074/delete', payload, {
    ...config,
  });

  if (statusCode !== 200 || status?.toLowerCase() === 'error') {
    throw new Error(message || 'Gagal menghapus data Digunggung');
  }

  return data;
};

digunggungApi.cancel = async ({ id, tglPembatalan }: TCancelRequest): Promise<TCancelResponse> => {
  const {
    data: { status, message, data, code, time, metaPage, total },
  } = await unifikasiClient.post('/IF_TXR_074/batal', {
    id,
    tglPembatalan,
  });

  console.log('Cancel Digunggung response:', { code, message, status });
  if (code === 0) {
    throw new Error(message || 'Gagal membatalkan data');
  }

  return {
    status,
    message,
    data,
    code,
    time,
    metaPage,
    total,
  };
};

export default digunggungApi;
