import { useMutation } from '@tanstack/react-query';
import type { TBaseResponseAPI, TDeleteNrRequest } from '../types/types';
import nrApi from '../utils/api';

const useDeleteDn = (props?: any) =>
  useMutation<TBaseResponseAPI<null>, Error, TDeleteNrRequest>({
    mutationKey: ['delete-nr'],
    mutationFn: (payload) => nrApi.deleteNr(payload),
    ...props,
  });

export default useDeleteDn;
