import { useQuery } from '@tanstack/react-query';
import type { TBaseResponseAPI, TGetListDataKOPNrResult } from '../types/types';
import queryKey from '../constant/queryKey';
import nrApi from '../utils/api';

const useGetKodeObjekPajakNr = (params?: Record<string, any>) =>
  useQuery<TBaseResponseAPI<TGetListDataKOPNrResult>>({
    queryKey: queryKey.getKodeObjekPajak(params),
    queryFn: () => nrApi.getKodeObjekPajakNr(params),
  });

export default useGetKodeObjekPajakNr;
