import { useMutation } from '@tanstack/react-query';
import type { TBaseResponseAPI, TDeleteRequest } from '../types/types';
import fakturApi from '../utils/api';

const useDeleteFakturPk = (props?: any) =>
  useMutation<TBaseResponseAPI<null>, Error, TDeleteRequest>({
    mutationKey: ['delete-faktur-pk'],
    mutationFn: (payload) => fakturApi.deleteFakturPK(payload),
    ...props,
  });

export default useDeleteFakturPk;
