import axios from 'src/lib/axios';

interface ChangePasswordPayload {
  email: string;
  password: string;
}

const apiProfile = (() => {

  const changePassword = async (payload: ChangePasswordPayload) => {
  const response = await axios.post('/sandbox/pasw-reset', payload, {
    headers: {
      'Content-Type': 'application/json',
      'x-token': localStorage.getItem('x-token') || '',
      Authorization: `Bearer ${localStorage.getItem('jwt_access_token') || ''}`,
    },
  });

  const body = response.data;

  if (response.status !== 200 || body.status !== 'success') {
    throw new Error(body.message);
  }

  return body;
};

  return {
    changePassword,
  };
})();

export default apiProfile;
