// src/views/VswpChecker.tsx
import { useState } from 'react';
import {
  Box,
  Card,
  Typography,
  RadioGroup,
  FormControlLabel,
  Radio,
  TextField,
  Button,
  Grid,
} from '@mui/material';
import { useGetVswp } from '../../hooks/useGetVswp';
// import { useGetVswp } from 'src/hooks/useGetVswp';

export default function VswpChecker() {
  const [identitas, setIdentitas] = useState<'npwp' | 'nik'>('npwp');
  const [inputValue, setInputValue] = useState('');

  const { mutate, data, isPending, error } = useGetVswp();

  const handleCek = () => {
    if (!inputValue) return;
    mutate({ type: identitas, value: inputValue });
  };

  const maxLength = identitas === 'npwp' ? 15 : 16;
  const isValid = inputValue.length === maxLength;

  return (
    <Card sx={{ p: 3, maxWidth: 400 }}>
      <Typography
        sx={{ fontWeight: 700, color: 'white', bgcolor: '#143b88', p: 1, borderRadius: 1 }}
        align="center"
      >
        Cek VSWP
      </Typography>

      <Box sx={{ mt: 3 }}>
        <Typography sx={{ fontWeight: 600, mb: 1 }}>Identitas</Typography>
        <RadioGroup
          row
          value={identitas}
          onChange={(e) => {
            setIdentitas(e.target.value as 'npwp' | 'nik');
            setInputValue('');
          }}
        >
          <FormControlLabel value="npwp" control={<Radio />} label="NPWP" />
          <FormControlLabel value="nik" control={<Radio />} label="NIK" />
        </RadioGroup>
      </Box>

      <Box sx={{ display: 'flex', gap: 1, mt: 2 }}>
        {/* <TextField
          fullWidth
          label={identitas.toUpperCase()}
          size="small"
          value={inputValue}
          onChange={(e) => setInputValue(e.target.value)}
        />
        <Button
          variant="contained"
          sx={{
            backgroundColor: '#143b88',
            borderRadius: '8px',
            px: 2,
            fontWeight: 600,
            textTransform: 'none',
          }}
          disabled={!inputValue || isPending}
          onClick={handleCek}
        >
          {isPending ? 'Memuat...' : 'Cek'}
        </Button> */}
        <TextField
          fullWidth
          label={identitas.toUpperCase()}
          size="small"
          inputProps={{
            maxLength, // batas input
            inputMode: 'numeric', // bantu input angka di mobile
          }}
          value={inputValue}
          onChange={(e) => {
            const val = e.target.value.replace(/\D/g, ''); // hanya angka
            setInputValue(val);
          }}
          helperText={
            identitas === 'npwp' ? `${inputValue.length}/15 digit` : `${inputValue.length}/16 digit`
          }
        />

        <Button
          variant="contained"
          sx={{
            backgroundColor: '#143b88',
            borderRadius: '8px',
            px: 2,
            fontWeight: 600,
            textTransform: 'none',
          }}
          disabled={!isValid || isPending}
          onClick={handleCek}
        >
          {isPending ? 'Memuat...' : 'Cek'}
        </Button>
      </Box>

      {error && (
        <Typography color="error" sx={{ mt: 2 }}>
          Gagal mengambil data. Periksa kembali {identitas.toUpperCase()}.
        </Typography>
      )}

      <Grid container spacing={1} sx={{ mt: 2 }}>
        <Grid size={12}>
          <TextField
            fullWidth
            label="Nama"
            size="small"
            value={data?.nama || ''}
            InputProps={{ readOnly: true }}
          />
        </Grid>
        <Grid size={12}>
          <TextField
            fullWidth
            label="Alamat"
            size="small"
            value={data?.alamat || ''}
            InputProps={{ readOnly: true }}
          />
        </Grid>
        <Grid size={6}>
          <TextField
            fullWidth
            label="Status"
            size="small"
            value={data?.statusWp || ''}
            InputProps={{ readOnly: true }}
          />
        </Grid>
        <Grid size={6}>
          <TextField
            fullWidth
            label="Status SPT"
            size="small"
            value={data?.statusSpt || ''}
            InputProps={{ readOnly: true }}
          />
        </Grid>
      </Grid>
    </Card>
  );
}
