// import Grid from '@mui/material/Grid';

import Box from '@mui/material/Box';
import Button from '@mui/material/Button';
import Grid from '@mui/material/Grid';
import MenuItem from '@mui/material/MenuItem';
import { useState } from 'react';
import { useFormContext } from 'react-hook-form';
import { useParams } from 'react-router';
import { Field } from 'src/components/hook-form';

type IdentitasProps = {
  isPengganti: boolean;
  //   disabledTambah: boolean;
  //   disabledHapus: boolean;
};

const Identitas = ({ isPengganti }: IdentitasProps) => {
  // const { dnId } = useParams();
  const { setValue } = useFormContext();

  const [jumlahKeterangan, setJumlahKeterangan] = useState<number>(0);

  const maxKeterangan = 5;

  const handleTambah = () => {
    if (jumlahKeterangan < maxKeterangan) {
      setJumlahKeterangan(jumlahKeterangan + 1);
    }
  };

  const handleHapus = () => {
    if (jumlahKeterangan > 0) {
      const newCount = jumlahKeterangan - 1;
      setJumlahKeterangan(newCount);
      // reset value form field yang dihapus
      setValue(`keterangan${newCount + 1}`, null);
    }
  };

  return (
    <>
      <Grid container rowSpacing={2} alignItems="center" columnSpacing={2} sx={{ mb: 4 }}>
        <Grid size={{ md: 6 }}>
          <Field.DatePicker name="tglPemotongan" label="Tanggal Pemotongan" />
        </Grid>
        <Grid size={{ md: 3 }}>
          <Field.DatePicker name="thnPajak" label="Tahun Pajak" view="year" format="YYYY" />
        </Grid>
        <Grid size={{ md: 3 }}>
          <Field.DatePicker name="msPajak" label="Masa Pajak" view="month" format="MM" />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Text name="idDipotong" label="Tax ID Number (TIN)" />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Text name="namaDipotong" label="Nama" />
        </Grid>
        <Grid size={{ md: 12 }}>
          <Field.Text name="email" label="Email (Optional)" />
        </Grid>
        <Grid size={{ md: 12 }}>
          <Field.Text name="almtDipotong" label="Alamat" multiline rows={2} />
        </Grid>
        <Grid size={{ md: 12 }}>
          <Field.Select name="kdNgrDipotong" label="Negara">
            <MenuItem>Indonesia</MenuItem>
          </Field.Select>
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Text name="tempatLahirDipotong" label="Tempat Lahir" />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.DatePicker name="tglLahirDipotong" label="Tanggal Lahir" />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Text name="noPasporDipotong" label="No. Paspor" />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Text name="noKitasDipotong" label="No.KITAS/KITAP" />
        </Grid>
      </Grid>
      <Box sx={{ display: 'flex', gap: 2, mb: 3 }}>
        <Box
          sx={{
            borderRadius: '18px',
            border: jumlahKeterangan >= maxKeterangan ? '1px solid #eee' : '1px solid #2e7d3280',
            color: jumlahKeterangan >= maxKeterangan ? '#eee' : '#2e7d3280',
            p: '0px 10px',
          }}
        >
          <Button disabled={jumlahKeterangan >= maxKeterangan} onClick={handleTambah}>
            Tambah Keterangan
          </Button>
        </Box>
        <Box
          sx={{
            borderRadius: '18px',
            border: jumlahKeterangan === 0 ? '1px solid #eee' : '1px solid #f44336',
            color: jumlahKeterangan === 0 ? '#eee' : '#f44336',
            p: '0px 10px',
          }}
        >
          <Button disabled={jumlahKeterangan === 0} onClick={handleHapus}>
            Hapus Keterangan
          </Button>
        </Box>
      </Box>

      <Box sx={{ mb: 3 }}>
        {Array.from({ length: jumlahKeterangan }).map((_, i) => (
          <Grid size={{ md: 12 }} key={i}>
            <Field.Text
              sx={{ mb: 2 }}
              name={`keterangan${i + 1}`}
              label={`Keterangan Tambahan ${i + 1}`}
            />
          </Grid>
        ))}
      </Box>
    </>
  );
};

export default Identitas;
