import { useMutation } from '@tanstack/react-query';
import type { TCancelRequest, TCancelResponse } from '../types/types';
import digunggungApi from '../utils/api';

const useCancelDigunggung = (props?: any) =>
  useMutation<TCancelResponse, Error, TCancelRequest>({
    mutationKey: ['cancel-digunggung'],
    mutationFn: (payload) => digunggungApi.cancel(payload),
    ...props,
  });

export default useCancelDigunggung;
