import dayjs from 'dayjs';
import { MIN_THN_PAJAK } from '../constant';

export const currentYear = dayjs().year();

export const getHighestStartingYear = (thnAwalUnifikasi: any) =>
  Math.max(MIN_THN_PAJAK, thnAwalUnifikasi);

export const selectedInitialMonth = ({ thnAwalUnifikasi, masaAwalUnifikasi }: any) => {
  const highestYear = getHighestStartingYear(thnAwalUnifikasi);
  return highestYear > thnAwalUnifikasi ? '01' : masaAwalUnifikasi;
};

export const determineStartingMonth = ({ thnPajak, thnAwalUnifikasi, masaAwalUnifikasi }: any) => {
  const highestYear = getHighestStartingYear(thnAwalUnifikasi);
  const initialMonth = selectedInitialMonth({ thnAwalUnifikasi, masaAwalUnifikasi });

  return thnPajak >= highestYear && thnPajak <= currentYear ? initialMonth : '';
};
